/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.moore.conversion;

import org.javatuples.Pair;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.fsm.lts.LtsNonDetModel;
import statemachine.model.fsm.moore.MooreModel;
import statemachine.model.fsm.moore.conversion.LocationLabelFormatter;
import statemachine.model.fsm.moore.conversion.LocationLabelParser;
import statemachine.model.fsm.moore.conversion.TransitionLabelFormatter;
import statemachine.model.fsm.moore.conversion.TransitionLabelParser;

public class LtsZip {
    public static LocationLabelFormatter defaultLocationLabelFormatter = (location, output) -> "{ " + location.getName() + " | " + output.getName() + " }";
    public static LocationLabelParser defaultLocationLabelParser = label -> {
        int start = label.indexOf(123);
        int mid = label.indexOf(124);
        int end = label.lastIndexOf(125);
        String location = label.substring(start + 1, mid).trim();
        String output = label.substring(mid + 1, end).trim();
        return new Pair((Object)new LocationState(location), (Object)new OutputAction(output));
    };
    public static TransitionLabelFormatter defaultTransitionLabelFormatter = input -> input.getName();
    public static TransitionLabelParser defaultTransitionLabelParser = inputlabel -> new InputAction(inputlabel);

    public static LtsNonDetModel zipMoore2Lts(MooreModel model, LocationLabelFormatter locationFormatter, TransitionLabelFormatter transitionFormatter) {
        LtsNonDetModel.ImmutableBuilder builder = new LtsNonDetModel.ImmutableBuilder();
        for (InputTransition trans : model.getModelTransitions()) {
            String label = transitionFormatter.apply(trans.getInput());
            Action action = new Action(label);
            String src = locationFormatter.apply((LocationState)trans.getSource(), (OutputAction)model.getOutputAt(trans.getSource()));
            String dest = locationFormatter.apply((LocationState)trans.getDestination(), (OutputAction)model.getOutputAt(trans.getDestination()));
            builder.addTransition(new LocationState(src), new LocationState(dest), action);
        }
        builder.setStartLocation((LocationState)model.getStartLocation());
        return builder.build();
    }

    public static LtsNonDetModel zipMoore2Lts(MooreModel model) {
        return LtsZip.zipMoore2Lts(model, defaultLocationLabelFormatter, defaultTransitionLabelFormatter);
    }
}

