/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.fsm.moore.format;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import org.javatuples.Pair;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.InputTransition;
import statemachine.model.fsm.moore.MooreModel;
import statemachine.model.fsm.moore.MooreNonDetModel;
import statemachine.model.fsm.moore.conversion.LtsZip;

public class Dot {
    public static MooreNonDetModel importMooreModel(List<String> lines) {
        MooreNonDetModel.ImmutableBuilder builder = new MooreNonDetModel.ImmutableBuilder();
        for (String line : lines) {
            int arrow;
            if (line.contains("__start0") && !line.contains("label")) {
                arrow = line.indexOf(45);
                String start = line.substring(arrow + 2).trim();
                LocationState startLocation = new LocationState(start);
                builder.setStartLocation(startLocation);
            }
            if (!line.contains("label")) continue;
            if (line.contains("record")) {
                int labelindex = line.indexOf("label");
                int labelStart = line.indexOf(34, labelindex);
                int labelEnd = line.indexOf(34, labelStart + 1);
                String label = line.substring(labelStart + 1, labelEnd).trim();
                Pair<LocationState, OutputAction> loc_output = LtsZip.defaultLocationLabelParser.apply(label);
                builder.addOutput((LocationState)loc_output.getValue0(), (OutputAction)loc_output.getValue1());
            }
            if (!line.contains("->")) continue;
            arrow = line.indexOf(45);
            int attrlist = line.indexOf(91);
            int labelattr = line.indexOf("label", attrlist);
            int labelbegin = line.indexOf(34, labelattr);
            int labelend = line.lastIndexOf(34);
            String from = line.substring(0, arrow).trim();
            String to = line.substring(arrow + 2, attrlist).trim();
            String label = line.substring(labelbegin + 1, labelend).trim();
            LocationState src = new LocationState(from);
            LocationState dst = new LocationState(to);
            InputAction action = new InputAction(label);
            builder.addTransition(src, dst, action);
        }
        return builder.build();
    }

    private static String formatID(String id) {
        return id.contains(" ") ? "\"" + id + "\"" : id;
    }

    public static List<String> export(MooreModel model) {
        String format;
        String label;
        ArrayList locations = new ArrayList(model.getLocations());
        locations.sort((p1, p2) -> p1.getName().compareTo(p2.getName()));
        ArrayList transitions = new ArrayList(model.getModelTransitions());
        BiFunction<InputTransition, InputTransition, Integer> comparator = (trans1, trans2) -> ComparisonChain.start().compare((Comparable)((Object)((LocationState)trans1.getSource()).getName()), (Comparable)((Object)((LocationState)trans2.getSource()).getName())).compare((Comparable)((Object)((LocationState)trans1.getDestination()).getName()), (Comparable)((Object)((LocationState)trans2.getDestination()).getName())).compare((Comparable)((Object)trans1.getInput().getName()), (Comparable)((Object)trans2.getInput().getName())).result();
        transitions.sort(comparator::apply);
        String indent = "    ";
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("digraph g {");
        lines.add("");
        lines.add(indent + "__start0 [label=\"\" shape=\"none\"]");
        lines.add(indent + "__start0 -> " + Dot.formatID(((LocationState)model.getStartLocation()).getName()));
        lines.add("");
        for (LocationState location : locations) {
            OutputAction output = (OutputAction)model.getOutputAt(location);
            String id = Dot.formatID(location.getName());
            label = LtsZip.defaultLocationLabelFormatter.apply(location, output);
            format = "%s%s [label=\"%s\" shape=\"record\" style=\"rounded\"]";
            lines.add(String.format(format, indent, id, label));
        }
        lines.add("");
        for (InputTransition transition : transitions) {
            String src = Dot.formatID(((LocationState)transition.getSource()).getName());
            String dst = Dot.formatID(((LocationState)transition.getDestination()).getName());
            label = transition.getInput().getName();
            format = "%s%s -> %s  [label=\"%s\"]";
            lines.add(String.format(format, indent, src, dst, label));
        }
        lines.add("}");
        return lines;
    }
}

