/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.time.mealy;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.javatuples.Pair;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.data.TimerVariable;
import statemachine.model.elements.location.Location;
import statemachine.model.elements.location.Timer;
import statemachine.model.elements.location.TimersLocationState;
import statemachine.model.elements.transition.MealyTimerTransition;
import statemachine.model.time.mealy.MealyTimerModel;

@NonNullByDefault
public abstract class MealyTimerBaseModel
implements MealyTimerModel {
    protected final ImmutableSet<InputAction> inputalphabet;
    protected final ImmutableSet<OutputAction> outputalphabet;
    protected final ImmutableSet<TimerVariable> timeralphabet;
    private final Location startLocation;
    private final TimersLocationState startState;
    private final ImmutableSet<Location> locations;
    private final ImmutableSet<MealyTimerTransition> transitions;
    protected final ImmutableSetMultimap<Location, MealyTimerTransition> loc2trans;

    protected MealyTimerBaseModel(ImmutableBuilder builder) {
        this.inputalphabet = builder.inputalphabet;
        this.outputalphabet = builder.outputalphabet;
        this.timeralphabet = builder.timeralphabet;
        this.startLocation = builder.startLocation;
        this.startState = builder.startState;
        this.locations = builder.locations;
        this.transitions = builder.transitions;
        this.loc2trans = builder.loc2trans;
    }

    @Override
    public @NonNull Location getStartLocation() {
        return this.startLocation;
    }

    @Override
    public @NonNull TimersLocationState getStartState() {
        return this.startState;
    }

    @Override
    public ImmutableSet<Location> getLocations() {
        return this.locations;
    }

    @Override
    public ImmutableSet<MealyTimerTransition> getModelTransitions() {
        return this.transitions;
    }

    @Override
    public ImmutableSet<MealyTimerTransition> getModelTransitions(Location location) {
        return this.loc2trans.get((Object)location);
    }

    @Override
    public ImmutableSet<InputAction> getInputAlphabet() {
        return this.inputalphabet;
    }

    @Override
    public ImmutableSet<OutputAction> getOutputAlphabet() {
        return this.outputalphabet;
    }

    public ImmutableSet<TimerVariable> getTimerAlphabet() {
        return this.timeralphabet;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull ImmutableSet<@NonNull MealyTimerTransition> getModelTransitions(Location location, InputAction action) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        @NonNull @NonNull ImmutableSet transitions = this.loc2trans.get((Object)location);
        for (MealyTimerTransition transition : transitions) {
            if (!transition.getInput().equals(action)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    public ImmutableSet<MealyTimerTransition> getModelTimeoutTransitions(Location location) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        ImmutableSet transitions = this.loc2trans.get((Object)location);
        for (MealyTimerTransition transition : transitions) {
            if (!transition.isTimeout()) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    public ImmutableSet<MealyTimerTransition> getModelTimeoutTransitions(Location location, TimerVariable timer) {
        ImmutableSet.Builder transitionsBuilder = ImmutableSet.builder();
        ImmutableSet<MealyTimerTransition> timeout_transitions = this.getModelTimeoutTransitions(location);
        for (MealyTimerTransition transition : timeout_transitions) {
            if (!transition.getTimedOutTimer().get().equals(timer)) continue;
            transitionsBuilder.add((Object)transition);
        }
        return transitionsBuilder.build();
    }

    @Override
    public Pair<TimersLocationState, OutputAction> evaluateTransition(TimersLocationState state, MealyTimerTransition transition) {
        Location src = state.getLocation();
        if (src != transition.getSource()) {
            new RuntimeException("error: given transition for other location then location given in current state");
        }
        HashSet<Timer> timers = new HashSet<Timer>((Collection<Timer>)state.getTimers());
        if (transition.hasUpdate()) {
            Long timeoutTime;
            String updateExpression = transition.getUpdate().get();
            String[] parts = updateExpression.trim().split("=");
            TimerVariable timerVar = new TimerVariable(parts[0]);
            Timer update = new Timer(timerVar, timeoutTime = Long.valueOf(parts[1]));
            Optional<Timer> oldtimer = state.getTimer(update.getName());
            if (oldtimer.isPresent()) {
                timers.remove(oldtimer.get());
            }
            timers.add(update);
        }
        Location dest = (Location)transition.getDestination();
        TimersLocationState newState = new TimersLocationState(dest, timers);
        OutputAction output = transition.getOutput();
        return new Pair((Object)newState, (Object)output);
    }

    @Override
    public Pair<TimersLocationState, Long> evaluateIdle(TimersLocationState state, Long requestedIdleTime) {
        long doneIdleTimeDone = 0L;
        long remainingIdleTime = requestedIdleTime;
        while (remainingIdleTime != 0L) {
            long timeoutTime = state.getTimeUntilTimeout();
            if (timeoutTime == -1L || timeoutTime > remainingIdleTime) {
                state = state.getNewStateAfterIdleTime(remainingIdleTime);
                doneIdleTimeDone = requestedIdleTime;
                remainingIdleTime = 0L;
                continue;
            }
            state = state.getNewStateAfterIdleTime(timeoutTime);
            doneIdleTimeDone += timeoutTime;
            remainingIdleTime -= timeoutTime;
            TreeSet<TimerVariable> timerVars = state.getTimedOutTimers();
            for (TimerVariable timerVar : timerVars) {
                ImmutableSet<MealyTimerTransition> timeoutTransitions = this.getModelTimeoutTransitions(state.getLocation(), timerVar);
                if (timeoutTransitions.isEmpty()) continue;
                remainingIdleTime = 0L;
                break;
            }
            if (remainingIdleTime == 0L) continue;
            state = state.removeTimedOutTimers();
        }
        return new Pair((Object)state, (Object)doneIdleTimeDone);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add("start location: " + this.startLocation);
        joiner.add("start state: " + this.startState);
        joiner.add("inputAlphabet: " + this.inputalphabet);
        joiner.add("outputAlphabet: " + this.outputalphabet);
        joiner.add("timerAlphabet: " + this.timeralphabet);
        joiner.add("locations:");
        for (Location location : this.getLocations()) {
            joiner.add(location.toString());
        }
        joiner.add("transitions:");
        for (MealyTimerTransition transition : this.getModelTransitions()) {
            joiner.add(transition.toString());
        }
        joiner.add("");
        return joiner.toString();
    }

    public static abstract class ImmutableBuilder {
        protected ImmutableSet<InputAction> inputalphabet;
        protected ImmutableSet<OutputAction> outputalphabet;
        protected ImmutableSet<TimerVariable> timeralphabet;
        protected Location startLocation;
        protected TimersLocationState startState;
        protected ImmutableSet<Location> locations;
        protected ImmutableSet<MealyTimerTransition> transitions;
        protected ImmutableSetMultimap<Location, MealyTimerTransition> loc2trans;
        protected ImmutableSet.Builder<Location> locationsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<MealyTimerTransition> transitionsBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<InputAction> inputalphabetBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<OutputAction> outputalphabetBuilder = ImmutableSet.builder();
        protected ImmutableSet.Builder<TimerVariable> timeralphabetBuilder = ImmutableSet.builder();
        protected ImmutableSetMultimap.Builder<Location, MealyTimerTransition> loc2transBuilder = ImmutableSetMultimap.builder();

        public ImmutableBuilder addTransition(Location src, Location dst, InputAction input, OutputAction output, String update) {
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            this.inputalphabetBuilder.add((Object)input);
            this.outputalphabetBuilder.add((Object)output);
            MealyTimerTransition transition = new MealyTimerTransition(src, dst, input, output, update);
            this.transitionsBuilder.add((Object)transition);
            this.loc2transBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addTransition(Location src, Location dst, InputAction input, OutputAction output) {
            this.addTransition(src, dst, input, output, null);
            return this;
        }

        public ImmutableBuilder addTransition(Location src, Location dst, TimerVariable timer, OutputAction output, String update) {
            this.locationsBuilder.add((Object[])new Location[]{src, dst});
            this.timeralphabetBuilder.add((Object)timer);
            this.outputalphabetBuilder.add((Object)output);
            MealyTimerTransition transition = new MealyTimerTransition(src, dst, timer, output, update);
            this.transitionsBuilder.add((Object)transition);
            this.loc2transBuilder.put((Object)src, (Object)transition);
            return this;
        }

        public ImmutableBuilder addTransition(Location src, Location dst, TimerVariable timer, OutputAction output) {
            this.addTransition(src, dst, timer, output, null);
            return this;
        }

        public ImmutableBuilder setStartLocation(Location startLocation) {
            this.startLocation = startLocation;
            return this;
        }

        public ImmutableBuilder addFromMealyTimerModel(MealyTimerModel model) {
            for (MealyTimerTransition trans : model.getModelTransitions()) {
                this.addTransition((Location)trans.getSource(), (Location)trans.getDestination(), trans.getInput(), trans.getOutput());
            }
            this.setStartLocation((Location)model.getStartLocation());
            return this;
        }

        protected void baseBuild() {
            this.inputalphabet = this.inputalphabetBuilder.build();
            this.outputalphabet = this.outputalphabetBuilder.build();
            this.timeralphabet = this.timeralphabetBuilder.build();
            this.startState = new TimersLocationState(this.startLocation, new HashSet<Timer>());
            this.locations = this.locationsBuilder.build();
            this.transitions = this.transitionsBuilder.build();
            this.loc2trans = this.loc2transBuilder.build();
        }
    }
}

