/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.time.mealy;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import statemachine.interfaces.system.properties.InputEnabledDeterministic;
import statemachine.interfaces.system.properties.TimeoutDeterministic;
import statemachine.model.Util;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.data.TimerVariable;
import statemachine.model.elements.location.Location;
import statemachine.model.elements.location.TimersLocationState;
import statemachine.model.elements.transition.MealyTimerTransition;
import statemachine.model.time.mealy.MealyTimerBaseModel;
import statemachine.model.time.mealy.MealyTimerModel;

@NonNullByDefault
public class MealyTimerDetEnabledModel
extends MealyTimerBaseModel
implements MealyTimerModel,
InputEnabledDeterministic<TimersLocationState, InputAction, MealyTimerTransition>,
TimeoutDeterministic<TimersLocationState, TimerVariable, MealyTimerTransition> {
    private MealyTimerDetEnabledModel(ImmutableBuilder builder) {
        super(builder);
        TimersLocationState state;
        for (Location location : this.loc2trans.keySet()) {
            for (InputAction action : this.inputalphabet) {
                state = new TimersLocationState(location, null);
                this.getSystemTransition(state, action);
            }
        }
        for (Location location : this.loc2trans.keySet()) {
            for (TimerVariable timervar : this.timeralphabet) {
                state = new TimersLocationState(location, null);
                this.getSystemTimeoutTransition(state, timervar);
            }
        }
    }

    public static MealyTimerDetEnabledModel fromMealyModel(MealyTimerModel model) {
        ImmutableBuilder builder = new ImmutableBuilder();
        builder.addFromMealyTimerModel(model);
        return builder.build();
    }

    @Override
    public MealyTimerTransition getSystemTransition(TimersLocationState state, InputAction action) {
        @NonNull ImmutableSet<@NonNull MealyTimerTransition> transitions = this.getModelTransitions(state.getLocation(), action);
        return Util.getTheTransition(transitions, state.getLocation().getName(), action.getName());
    }

    @Override
    public Optional<MealyTimerTransition> getSystemTimeoutTransition(TimersLocationState state, TimerVariable timerVariable) {
        return this.getModelTimeoutTransition(state.getLocation(), timerVariable);
    }

    public Optional<MealyTimerTransition> getModelTimeoutTransition(Location location, TimerVariable timerVariable) {
        ImmutableSet<MealyTimerTransition> transitions = this.getModelTimeoutTransitions(location, timerVariable);
        return Util.getOptionalTransition(transitions);
    }

    public static final class ImmutableBuilder
    extends MealyTimerBaseModel.ImmutableBuilder {
        public MealyTimerDetEnabledModel build() {
            super.baseBuild();
            return new MealyTimerDetEnabledModel(this);
        }
    }
}

