/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.time.mealy.conversion;

import org.javatuples.Quartet;
import statemachine.model.elements.action.Action;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.data.TimerVariable;
import statemachine.model.elements.location.Location;
import statemachine.model.elements.location.LocationState;
import statemachine.model.elements.transition.ActionTransition;
import statemachine.model.elements.transition.MealyTimerTransition;
import statemachine.model.fsm.lts.LtsModel;
import statemachine.model.fsm.lts.LtsNonDetModel;
import statemachine.model.time.mealy.MealyTimerModel;
import statemachine.model.time.mealy.conversion.MealyTimerNonDetModel;
import statemachine.model.time.mealy.conversion.TransitionLabelFormatter;
import statemachine.model.time.mealy.conversion.TransitionLabelParser;

public class LtsZip {
    public static TransitionLabelFormatter defaultTransitionLabelFormatter = (input, timeoutvar, output, update) -> {
        if (!update.equals("")) {
            update = " " + update;
        }
        if (!timeoutvar.equals("")) {
            input = "timeout[" + timeoutvar + "]";
        }
        return input + "/" + output + update;
    };
    public static TransitionLabelParser defaultTransitionLabelParser = new TransitionLabelParser(){

        @Override
        public Quartet<String, String, String, String> apply(String label) {
            String input = "";
            String timedOutTimerVariable = "";
            String update = "";
            String[] parts = label.split("/");
            input = parts[0].trim();
            String output = parts[1].trim();
            if (input.contains("timeout[")) {
                timedOutTimerVariable = input.substring(8).replaceAll("\\]", "");
                input = "timeout";
            }
            if (output.contains("=")) {
                parts = output.split("\\s+");
                output = parts[0].trim();
                update = parts[1].trim();
            }
            return new Quartet((Object)input, (Object)timedOutTimerVariable, (Object)output, (Object)update);
        }
    };

    public static LtsNonDetModel zipMealyTimer2Lts(MealyTimerModel model, TransitionLabelFormatter transitionFormatter) {
        LtsNonDetModel.ImmutableBuilder builder = new LtsNonDetModel.ImmutableBuilder();
        for (MealyTimerTransition trans : model.getModelTransitions()) {
            String timedOutTimerVariable = trans.getTimedOutTimer().isPresent() ? trans.getTimedOutTimer().get().getName() : "";
            String update = trans.getUpdate().isPresent() ? trans.getUpdate().get().toString() : "";
            String label = transitionFormatter.apply(trans.getInput().getName(), timedOutTimerVariable, trans.getOutput().getName(), update);
            Action action = new Action(label);
            builder.addTransition(new LocationState(((Location)trans.getSource()).getName()), new LocationState(((Location)trans.getDestination()).getName()), action);
        }
        builder.setStartLocation(new LocationState(((Location)model.getStartLocation()).getName()));
        return builder.build();
    }

    public static LtsNonDetModel zipMealyTimer2Lts(MealyTimerModel model) {
        return LtsZip.zipMealyTimer2Lts(model, defaultTransitionLabelFormatter);
    }

    public static MealyTimerNonDetModel unzipLts2MealyTimer(LtsModel model, TransitionLabelParser labelParser) {
        MealyTimerNonDetModel.ImmutableBuilder builder = new MealyTimerNonDetModel.ImmutableBuilder();
        for (ActionTransition trans : model.getModelTransitions()) {
            String label = trans.getAction().getName();
            Quartet<String, String, String, String> parsed = labelParser.apply(label);
            String input = (String)parsed.getValue0();
            String timedOutTimerVariable = (String)parsed.getValue1();
            String output = (String)parsed.getValue2();
            String update = (String)parsed.getValue3();
            OutputAction outputAction = new OutputAction(output);
            if (!timedOutTimerVariable.equals("")) {
                TimerVariable timerVariable = new TimerVariable(timedOutTimerVariable);
                if (update.equals("")) {
                    builder.addTransition(new Location(((LocationState)trans.getSource()).getName()), new Location(((LocationState)trans.getDestination()).getName()), timerVariable, outputAction);
                    continue;
                }
                builder.addTransition(new Location(((LocationState)trans.getSource()).getName()), new Location(((LocationState)trans.getDestination()).getName()), timerVariable, outputAction, update);
                continue;
            }
            InputAction inputAction = new InputAction(input);
            if (update.equals("")) {
                builder.addTransition(new Location(((LocationState)trans.getSource()).getName()), new Location(((LocationState)trans.getDestination()).getName()), inputAction, outputAction);
                continue;
            }
            builder.addTransition(new Location(((LocationState)trans.getSource()).getName()), new Location(((LocationState)trans.getDestination()).getName()), inputAction, outputAction, update);
        }
        builder.setStartLocation(new Location(((LocationState)model.getStartLocation()).getName()));
        return builder.build();
    }

    public static MealyTimerNonDetModel unzipLts2MealyTimer(LtsModel model) {
        return LtsZip.unzipLts2MealyTimer(model, defaultTransitionLabelParser);
    }
}

