/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.time.mealy.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.javatuples.Pair;
import statemachine.interfaces.system.execution.OutputListener;
import statemachine.interfaces.system.execution.SendTimedInputWordGetTimedOutputWord;
import statemachine.interfaces.system.execution.StartInterrupt;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.time.mealy.MealyTimerDetEnabledModel;
import statemachine.model.time.mealy.execution.MealyTimerDetEnabledAsyncRunner;

public class MealyTimerDetEnableAsyncTraceRunner
implements SendTimedInputWordGetTimedOutputWord<InputAction, OutputAction, Long>,
StartInterrupt {
    private MealyTimerDetEnabledAsyncRunner runner;
    private long epsilon;
    private ArrayList<Pair<OutputAction, Long>> timedOutputWord;
    private static boolean debug = false;
    private Long startTime;

    public MealyTimerDetEnableAsyncTraceRunner(MealyTimerDetEnabledModel model, long epsilon) {
        this.runner = new MealyTimerDetEnabledAsyncRunner(model);
        this.epsilon = epsilon;
        this.runner.setOnOutputListener(new OutputListener<OutputAction>(){

            @Override
            public void onOutput(OutputAction output) {
                Long time = System.currentTimeMillis() - MealyTimerDetEnableAsyncTraceRunner.this.startTime;
                if (debug) {
                    System.out.println(time + ": out" + output);
                }
                MealyTimerDetEnableAsyncTraceRunner.this.timedOutputWord.add(new Pair((Object)output, (Object)time));
            }
        });
    }

    @Override
    public void start() {
        this.runner.start();
    }

    @Override
    public void interrupt() {
        this.runner.interrupt();
    }

    @Override
    public List<Pair<OutputAction, Long>> sendTimedInputWord(List<Pair<InputAction, Long>> timedInputWord) {
        this.runner.reset();
        this.timedOutputWord = new ArrayList();
        this.startTime = System.currentTimeMillis();
        long lastInputTime = 0L;
        Timer timer = new Timer();
        for (Pair<InputAction, Long> pair : timedInputWord) {
            final InputAction input = (InputAction)pair.getValue0();
            Long time = (Long)pair.getValue1();
            lastInputTime = time;
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    MealyTimerDetEnableAsyncTraceRunner.this.runner.sendInput(input);
                    if (debug) {
                        Long realtime = System.currentTimeMillis() - MealyTimerDetEnableAsyncTraceRunner.this.startTime;
                        System.out.println(realtime + ": send " + input);
                    }
                }
            }, time);
        }
        try {
            Thread.sleep(lastInputTime + this.epsilon);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        timer.cancel();
        return this.timedOutputWord;
    }

    public static List<Pair<OutputAction, Long>> runTimedInputWord(MealyTimerDetEnabledModel model, List<Pair<InputAction, Long>> timedInputWord, long epsilon) {
        MealyTimerDetEnableAsyncTraceRunner traceRunner = new MealyTimerDetEnableAsyncTraceRunner(model, epsilon);
        traceRunner.start();
        List<Pair<OutputAction, Long>> timedOutputWord = traceRunner.sendTimedInputWord(timedInputWord);
        traceRunner.interrupt();
        return timedOutputWord;
    }
}

