/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.time.mealy.execution;

import java.util.HashMap;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.javatuples.Pair;
import statemachine.interfaces.system.execution.OutputListener;
import statemachine.interfaces.system.execution.Reset;
import statemachine.interfaces.system.execution.SendInputListenOutput;
import statemachine.interfaces.system.execution.StartInterrupt;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.data.TimerVariable;
import statemachine.model.elements.location.Location;
import statemachine.model.elements.location.TimersLocationState;
import statemachine.model.elements.transition.MealyTimerTransition;
import statemachine.model.elements.transition.Transition;
import statemachine.model.time.mealy.MealyTimerDetEnabledModel;

public class MealyTimerDetEnabledAsyncRunner
extends Thread
implements SendInputListenOutput<InputAction, OutputAction>,
Reset,
StartInterrupt {
    private OutputListener<OutputAction> onOutputListener;
    private LinkedBlockingQueue<Pair<TimerVariable, InputAction>> queue;
    private HashMap<TimerVariable, Timer> timerVar2timer;
    private MealyTimerDetEnabledModel model;
    private Location location;
    private static boolean debug = false;

    public MealyTimerDetEnabledAsyncRunner(MealyTimerDetEnabledModel model) {
        this.model = model;
        this.location = model.getStartLocation();
        this.queue = new LinkedBlockingQueue();
        this.timerVar2timer = new HashMap();
    }

    @Override
    public void setOnOutputListener(OutputListener<OutputAction> onOutputListener) {
        this.onOutputListener = onOutputListener;
    }

    @Override
    public void sendInput(InputAction input) {
        Pair event = new Pair(null, (Object)input);
        try {
            this.queue.put((Pair<TimerVariable, InputAction>)event);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reset() {
        for (Timer timer : this.timerVar2timer.values()) {
            timer.cancel();
        }
        this.timerVar2timer.clear();
        this.queue.clear();
        this.location = this.model.getStartLocation();
    }

    private void cleanup() {
        this.reset();
    }

    private void executeTransition(Pair<TimerVariable, InputAction> event) {
        InputAction input = (InputAction)event.getValue1();
        TimerVariable timerVar = (TimerVariable)event.getValue0();
        Transition transition = null;
        if (timerVar != null) {
            Optional<MealyTimerTransition> optTransition = this.model.getModelTimeoutTransition(this.location, timerVar);
            if (optTransition.isPresent()) {
                transition = optTransition.get();
            } else if (debug) {
                System.out.println("run: missed timeout " + timerVar + " because in current location no timeout transition defined");
            }
        } else if (input != null) {
            transition = this.model.getSystemTransition(new TimersLocationState(this.location, null), input);
        }
        if (transition == null) {
            return;
        }
        if (debug) {
            System.out.println("run: take trans: " + transition);
        }
        this.location = (Location)transition.getDestination();
        this.onOutputListener.onOutput(((MealyTimerTransition)transition).getOutput());
        if (((MealyTimerTransition)transition).hasUpdate()) {
            String updateExpression = ((MealyTimerTransition)transition).getUpdate().get();
            String[] parts = updateExpression.trim().split("=");
            final TimerVariable timerVarUpdated = new TimerVariable(parts[0]);
            Long timeoutTime = Long.valueOf(parts[1]);
            if (this.timerVar2timer.containsKey(timerVarUpdated)) {
                this.timerVar2timer.get(timerVarUpdated).cancel();
            }
            Timer internalTimer = new Timer();
            internalTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Pair newevent = new Pair((Object)timerVarUpdated, null);
                    try {
                        MealyTimerDetEnabledAsyncRunner.this.queue.put(newevent);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Couldn't enqueue timeout event of timer");
                    }
                }
            }, timeoutTime);
            this.timerVar2timer.put(timerVarUpdated, internalTimer);
        }
    }

    @Override
    public void run() {
        while (true) {
            Pair<TimerVariable, InputAction> event;
            block5: {
                event = null;
                if (Thread.currentThread().isInterrupted()) {
                    this.cleanup();
                    break;
                }
                try {
                    event = this.queue.take();
                    if (!debug) break block5;
                    System.out.println("event: " + event);
                }
                catch (InterruptedException e1) {
                    this.cleanup();
                    break;
                }
            }
            this.executeTransition(event);
        }
        if (debug) {
            System.out.println("run: end TimedSul thread");
        }
    }
}

