/*
 * Decompiled with CFR 0.152.
 */
package statemachine.model.time.mealy.walker;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.javatuples.Pair;
import statemachine.interfaces.system.walker.StepInputGetOutput;
import statemachine.model.elements.action.InputAction;
import statemachine.model.elements.action.OutputAction;
import statemachine.model.elements.data.TimerVariable;
import statemachine.model.elements.location.TimersLocationState;
import statemachine.model.elements.transition.MealyTimerTransition;
import statemachine.model.time.mealy.MealyTimerDetEnabledModel;
import statemachine.model.time.mealy.walker.MealyTimerBaseWalker;

@NonNullByDefault
public class MealyTimerDetEnabledWalker
extends MealyTimerBaseWalker<MealyTimerDetEnabledModel>
implements StepInputGetOutput<TimersLocationState, InputAction, OutputAction> {
    public static List<Pair<OutputAction, Long>> walkTimedInputWord(MealyTimerDetEnabledModel model, List<Pair<InputAction, Long>> timedInputWord) {
        ArrayList<Pair<OutputAction, Long>> timedOutputWord = new ArrayList<Pair<OutputAction, Long>>();
        MealyTimerDetEnabledWalker walker = new MealyTimerDetEnabledWalker(model);
        long timePassed = 0L;
        for (Pair<InputAction, Long> inputTimePair : timedInputWord) {
            long inputTime = (Long)inputTimePair.getValue1();
            InputAction inputAction = (InputAction)inputTimePair.getValue0();
            List<Pair<OutputAction, Long>> timedOutputs = walker.waitDelay(inputTime - timePassed);
            for (Pair<OutputAction, Long> outputTimePair : timedOutputs) {
                OutputAction output = (OutputAction)outputTimePair.getValue0();
                Long time = (Long)outputTimePair.getValue1();
                timedOutputWord.add((Pair<OutputAction, Long>)new Pair((Object)output, (Object)(timePassed + time)));
            }
            timePassed = inputTime;
            OutputAction outputAction = walker.stepInput(inputAction);
            timedOutputWord.add((Pair<OutputAction, Long>)new Pair((Object)outputAction, (Object)timePassed));
        }
        return timedOutputWord;
    }

    public MealyTimerDetEnabledWalker(MealyTimerDetEnabledModel model) {
        super(model);
    }

    @Override
    public boolean checkInputPossible(InputAction action) {
        return true;
    }

    @Override
    public OutputAction stepInput(InputAction action) {
        MealyTimerTransition transition = ((MealyTimerDetEnabledModel)this.model).getSystemTransition(this.currentState, action);
        Pair<TimersLocationState, OutputAction> result = ((MealyTimerDetEnabledModel)this.model).evaluateTransition(this.currentState, transition);
        this.currentState = (TimersLocationState)result.getValue0();
        OutputAction output = (OutputAction)result.getValue1();
        return output;
    }

    public List<Pair<OutputAction, Long>> waitDelay(long delay) {
        ArrayList<Pair<OutputAction, Long>> timedoutputs = new ArrayList<Pair<OutputAction, Long>>();
        Pair<TimersLocationState, Long> idleResult = ((MealyTimerDetEnabledModel)this.model).evaluateIdle(this.currentState, delay);
        this.currentState = (TimersLocationState)idleResult.getValue0();
        long dt = (Long)idleResult.getValue1();
        for (long remainingTime = delay - dt; remainingTime != 0L; remainingTime -= dt) {
            MealyTimerTransition transition = null;
            TreeSet<TimerVariable> timerVars = this.currentState.getTimedOutTimers();
            for (TimerVariable timerVar : timerVars) {
                ImmutableSet<MealyTimerTransition> timeoutTransitions = ((MealyTimerDetEnabledModel)this.model).getModelTimeoutTransitions(this.currentState.getLocation(), timerVar);
                if (timeoutTransitions.isEmpty()) continue;
                transition = (MealyTimerTransition)timeoutTransitions.asList().get(0);
                break;
            }
            if (transition == null) {
                throw new RuntimeException("error: timeout transition should exist");
            }
            Pair<TimersLocationState, OutputAction> result = ((MealyTimerDetEnabledModel)this.model).evaluateTransition(this.currentState, transition);
            this.currentState = (TimersLocationState)result.getValue0();
            OutputAction output = (OutputAction)result.getValue1();
            this.currentState = this.currentState.removeTimedOutTimers();
            timedoutputs.add((Pair<OutputAction, Long>)new Pair((Object)output, (Object)(delay - remainingTime)));
            idleResult = ((MealyTimerDetEnabledModel)this.model).evaluateIdle(this.currentState, remainingTime);
            this.currentState = (TimersLocationState)idleResult.getValue0();
            dt = (Long)idleResult.getValue1();
        }
        return timedoutputs;
    }
}

