/*
 * Decompiled with CFR 0.152.
 */
package statemachine.util;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.function.Function;

public class KeyLookup<K, V> {
    private HashMap<K, V> key2value = new HashMap();
    private Function<V, K> getKeyFromValueFunction;

    public KeyLookup(ImmutableSet<V> set, Function<V, K> getKeyFromValueFunction) {
        this.getKeyFromValueFunction = getKeyFromValueFunction;
        for (Object value : set) {
            K key = this.getKeyFromValueFunction.apply(value);
            this.key2value.put(key, value);
        }
    }

    public V get(K key) {
        return this.key2value.get(key);
    }

    public V getValueFromSetEqualTo(V value) {
        K key = this.getKeyFromValueFunction.apply(value);
        return this.get(key);
    }
}

