/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.symtab;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.symtab.FieldSymbol;
import org.antlr.symtab.MemberSymbol;
import org.antlr.symtab.Symbol;
import org.antlr.symtab.SymbolWithScope;
import org.antlr.symtab.Type;
import org.antlr.v4.runtime.ParserRuleContext;

public abstract class DataAggregateSymbol
extends SymbolWithScope
implements MemberSymbol,
Type {
    protected ParserRuleContext defNode;
    protected int nextFreeFieldSlot = 0;
    protected int typeIndex;

    public DataAggregateSymbol(String name) {
        super(name);
    }

    public void setDefNode(ParserRuleContext defNode) {
        this.defNode = defNode;
    }

    public ParserRuleContext getDefNode() {
        return this.defNode;
    }

    @Override
    public void define(Symbol sym) throws IllegalArgumentException {
        if (!(sym instanceof MemberSymbol)) {
            throw new IllegalArgumentException("sym is " + sym.getClass().getSimpleName() + " not MemberSymbol");
        }
        super.define(sym);
        this.setSlotNumber(sym);
    }

    public List<MemberSymbol> getSymbols() {
        return super.getSymbols();
    }

    public Map<String, ? extends MemberSymbol> getMembers() {
        return super.getMembers();
    }

    public Symbol resolveMember(String name) {
        Symbol s = (Symbol)this.symbols.get(name);
        if (s instanceof MemberSymbol) {
            return s;
        }
        return null;
    }

    public Symbol resolveField(String name) {
        Symbol s = this.resolveMember(name);
        if (s instanceof FieldSymbol) {
            return s;
        }
        return null;
    }

    public int getNumberOfDefinedFields() {
        int n = 0;
        for (MemberSymbol s : this.getSymbols()) {
            if (!(s instanceof FieldSymbol)) continue;
            ++n;
        }
        return n;
    }

    public int getNumberOfFields() {
        return this.getNumberOfDefinedFields();
    }

    public List<? extends FieldSymbol> getDefinedFields() {
        ArrayList<FieldSymbol> fields = new ArrayList<FieldSymbol>();
        for (MemberSymbol s : this.getSymbols()) {
            if (!(s instanceof FieldSymbol)) continue;
            fields.add((FieldSymbol)s);
        }
        return fields;
    }

    public List<? extends FieldSymbol> getFields() {
        return this.getDefinedFields();
    }

    public void setSlotNumber(Symbol sym) {
        if (sym instanceof FieldSymbol) {
            FieldSymbol fsym = (FieldSymbol)sym;
            fsym.slot = this.nextFreeFieldSlot++;
        }
    }

    @Override
    public int getSlotNumber() {
        return -1;
    }

    @Override
    public int getTypeIndex() {
        return this.typeIndex;
    }

    public void setTypeIndex(int typeIndex) {
        this.typeIndex = typeIndex;
    }
}

