/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.algorithms.graph.scc;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.algorithms.graph.scc.SCCCollector;
import net.automatalib.algorithms.graph.scc.SCCListener;
import net.automatalib.algorithms.graph.scc.TarjanSCCVisitor;
import net.automatalib.graphs.Graph;
import net.automatalib.util.graphs.traversal.GraphTraversal;

@ParametersAreNonnullByDefault
public abstract class SCCs {
    private SCCs() {
    }

    public static <N, E> void findSCCs(Graph<N, E> graph, SCCListener<N> listener) {
        TarjanSCCVisitor vis = new TarjanSCCVisitor(graph, listener);
        for (Object node : graph) {
            if (vis.hasVisited(node)) continue;
            GraphTraversal.depthFirst(graph, node, vis);
        }
    }

    @Nonnull
    public static <N, E> List<List<N>> collectSCCs(Graph<N, E> graph) {
        SCCCollector coll = new SCCCollector();
        SCCs.findSCCs(graph, coll);
        return coll.getSCCList();
    }
}

