/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.algorithms.graph.scc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.algorithms.graph.scc.SCCListener;
import net.automatalib.algorithms.graph.scc.TarjanSCCRecord;
import net.automatalib.commons.util.Holder;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.graphs.Graph;
import net.automatalib.util.graphs.traversal.GraphTraversalAction;
import net.automatalib.util.graphs.traversal.GraphTraversalVisitor;

@ParametersAreNonnullByDefault
public class TarjanSCCVisitor<N, E>
implements GraphTraversalVisitor<N, E, TarjanSCCRecord> {
    private static final int NODE_FINISHED = -1;
    private int counter = 0;
    private final MutableMapping<N, TarjanSCCRecord> records;
    private final List<TarjanSCCRecord> currentScc = new ArrayList<TarjanSCCRecord>();
    private final List<N> currentSccNodes = new ArrayList<N>();
    private final SCCListener<N> listener;

    public TarjanSCCVisitor(Graph<N, E> graph, SCCListener<N> listener) {
        this.records = graph.createStaticNodeMapping();
        this.listener = listener;
    }

    @Override
    public GraphTraversalAction processInitial(N initialNode, Holder<TarjanSCCRecord> outData) {
        outData.value = this.createRecord();
        return GraphTraversalAction.EXPLORE;
    }

    @Override
    public boolean startExploration(N node, TarjanSCCRecord data) {
        this.records.put(node, data);
        return true;
    }

    @Override
    public void finishExploration(N node, TarjanSCCRecord data) {
        this.currentScc.add(data);
        this.currentSccNodes.add(node);
        if (data.lowLink == data.number) {
            for (TarjanSCCRecord tr : this.currentScc) {
                tr.lowLink = -1;
            }
            this.listener.foundSCC(this.currentSccNodes);
            this.currentScc.clear();
            this.currentSccNodes.clear();
        }
    }

    @Override
    public GraphTraversalAction processEdge(N srcNode, TarjanSCCRecord srcData, E edge, N tgtNode, Holder<TarjanSCCRecord> dataHolder) {
        int tgtNum;
        TarjanSCCRecord rec = (TarjanSCCRecord)this.records.get(tgtNode);
        if (rec == null) {
            rec = this.createRecord();
            dataHolder.value = rec;
            return GraphTraversalAction.EXPLORE;
        }
        if (rec.lowLink != -1 && (tgtNum = rec.number) < srcData.lowLink) {
            srcData.lowLink = tgtNum;
        }
        return GraphTraversalAction.IGNORE;
    }

    @Override
    public void backtrackEdge(N srcNode, TarjanSCCRecord srcData, E edge, N tgtNode, TarjanSCCRecord tgtData) {
        int tgtLl = tgtData.lowLink;
        if (tgtData.lowLink != -1 && tgtLl < srcData.lowLink) {
            srcData.lowLink = tgtLl;
        }
    }

    public boolean hasVisited(N node) {
        return this.records.get(node) != null;
    }

    private TarjanSCCRecord createRecord() {
        return new TarjanSCCRecord(this.counter++);
    }
}

