/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.UniversalAutomaton;

@ParametersAreNonnullByDefault
public interface MutableAutomaton<S, I, T, SP, TP>
extends UniversalAutomaton<S, I, T, SP, TP> {
    public void clear();

    @Nonnull
    public S addState(@Nullable SP var1);

    @Nonnull
    default public S addInitialState(@Nullable SP property) {
        S state = this.addState(property);
        this.setInitial(state, true);
        return state;
    }

    @Nonnull
    default public S addState() {
        return this.addState(null);
    }

    @Nonnull
    default public S addInitialState() {
        return this.addInitialState(null);
    }

    public void setInitial(S var1, boolean var2);

    public void setStateProperty(S var1, @Nullable SP var2);

    public void setTransitionProperty(T var1, @Nullable TP var2);

    @Nonnull
    public T createTransition(S var1, @Nullable TP var2);

    default public void addTransition(S state, @Nullable I input, T transition) {
        HashSet transitions = new HashSet(this.getTransitions(state, input));
        if (!transitions.add(transition)) {
            return;
        }
        this.setTransitions(state, input, transitions);
    }

    default public void addTransitions(S state, @Nullable I input, Collection<? extends T> transitions) {
        HashSet newTransitions = new HashSet(this.getTransitions(state, input));
        if (!newTransitions.addAll(transitions)) {
            return;
        }
        this.setTransitions(state, input, newTransitions);
    }

    public void setTransitions(S var1, @Nullable I var2, Collection<? extends T> var3);

    default public void removeTransition(S state, @Nullable I input, T transition) {
        HashSet transitions = new HashSet(this.getTransitions(state, input));
        if (!transitions.remove(transition)) {
            return;
        }
        this.setTransitions(state, input, transitions);
    }

    default public void removeAllTransitions(S state, @Nullable I input) {
        this.setTransitions(state, input, Collections.emptySet());
    }

    public void removeAllTransitions(S var1);

    @Nonnull
    default public T addTransition(S state, @Nullable I input, S successor, @Nullable TP properties) {
        T trans = this.createTransition(successor, properties);
        this.addTransition(state, input, trans);
        return trans;
    }

    @Nonnull
    default public T copyTransition(T trans, S succ) {
        Object property = this.getTransitionProperty(trans);
        return this.createTransition(succ, property);
    }
}

