/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.MutableAutomaton;

@ParametersAreNonnullByDefault
public interface ShrinkableAutomaton<S, I, T, SP, TP>
extends MutableAutomaton<S, I, T, SP, TP> {
    public static <S, I, T, SP, TP> void unlinkState(MutableAutomaton<S, I, T, SP, TP> automaton, S state, S replacement, Collection<I> inputs) {
        for (Object curr : automaton) {
            if (state.equals(curr)) continue;
            for (I input : inputs) {
                Collection transitions = automaton.getTransitions(curr, input);
                if (transitions.isEmpty()) continue;
                boolean modified = false;
                LinkedList modTransitions = new LinkedList(transitions);
                ListIterator<T> it = modTransitions.listIterator();
                while (it.hasNext()) {
                    Object trans = it.next();
                    if (automaton.getSuccessor(trans) != state) continue;
                    if (replacement == null) {
                        it.remove();
                    } else {
                        T transRep = automaton.copyTransition(trans, replacement);
                        it.set(transRep);
                    }
                    modified = true;
                }
                if (!modified) continue;
                automaton.setTransitions(curr, input, modTransitions);
            }
        }
    }

    default public void removeState(S state) {
        this.removeState(state, null);
    }

    public void removeState(S var1, @Nullable S var2);
}

