/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base;

import net.automatalib.automata.Automaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.commons.util.array.ResizingObjectArray;
import net.automatalib.commons.util.mappings.MutableMapping;

public class StateIDGrowingMapping<S, V>
implements MutableMapping<S, V> {
    private final Automaton<S, ?, ?> automaton;
    private final StateIDs<S> stateIds;
    private final ResizingObjectArray storage;

    public StateIDGrowingMapping(Automaton<S, ?, ?> automaton, StateIDs<S> stateIds) {
        this.automaton = automaton;
        this.stateIds = stateIds;
        this.storage = new ResizingObjectArray(automaton.size());
    }

    @Override
    public V get(S elem) {
        int id = this.stateIds.getStateId(elem);
        if (id < this.storage.array.length) {
            return (V)this.storage.array[id];
        }
        return null;
    }

    @Override
    public V put(S key, V value) {
        int id = this.stateIds.getStateId(key);
        if (id >= this.storage.array.length) {
            this.storage.ensureCapacity(this.automaton.size());
        }
        Object old = this.storage.array[id];
        this.storage.array[id] = value;
        return (V)old;
    }
}

