/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import java.util.Collection;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Alphabet;

public abstract class AbstractCompactDeterministic<I, T, SP, TP>
implements MutableDeterministic<Integer, I, T, SP, TP>,
StateIDs<Integer>,
UniversalFiniteAlphabetAutomaton<Integer, I, T, SP, TP>,
MutableDeterministic.StateIntAbstraction<I, T, SP, TP>,
MutableDeterministic.FullIntAbstraction<T, SP, TP> {
    public static final float DEFAULT_RESIZE_FACTOR = 1.5f;
    public static final int DEFAULT_INIT_CAPACITY = 11;
    protected final Alphabet<I> alphabet;
    protected final int alphabetSize;
    protected Object[] transitions;
    protected int stateCapacity;
    protected int numStates;
    protected int initial = -1;
    protected final float resizeFactor;

    protected static final int getId(Integer id) {
        return id != null ? id : -1;
    }

    protected static final Integer makeId(int id) {
        return id != -1 ? Integer.valueOf(id) : null;
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet, int stateCapacity) {
        this(alphabet, stateCapacity, 1.5f);
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet, float resizeFactor) {
        this(alphabet, 11, resizeFactor);
    }

    public AbstractCompactDeterministic(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
        this.transitions = new Object[stateCapacity * this.alphabetSize];
        this.resizeFactor = resizeFactor;
        this.stateCapacity = stateCapacity;
    }

    protected void ensureCapacity() {
    }

    public final void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.stateCapacity) {
            return;
        }
        int newCap = (int)((float)this.stateCapacity * this.resizeFactor);
        if (newCap < newCapacity) {
            newCap = newCapacity;
        }
        Object[] newTrans = new Object[newCap * this.alphabetSize];
        System.arraycopy(this.transitions, 0, newTrans, 0, this.stateCapacity * this.alphabetSize);
        this.transitions = newTrans;
        this.stateCapacity = newCap;
        this.ensureCapacity();
    }

    @Override
    public int size() {
        return this.numStates;
    }

    @Override
    public void setInitialState(int stateId) {
        this.initial = stateId;
    }

    @Override
    public void setInitialState(Integer state) {
        this.setInitialState(AbstractCompactDeterministic.getId(state));
    }

    @Override
    public void setTransition(int state, int inputIdx, T trans) {
        this.transitions[state * this.alphabetSize + inputIdx] = trans;
    }

    @Override
    public void setTransition(int state, I input, T trans) {
        this.setTransition(state, (I)this.alphabet.getSymbolIndex(input), trans);
    }

    @Override
    public void setTransition(int stateId, int inputIdx, int succId) {
        this.setTransition(stateId, (I)inputIdx, succId, (TP)null);
    }

    @Override
    public void setTransition(int stateId, int inputIdx, int succId, TP property) {
        this.setTransition(stateId, (I)inputIdx, this.createTransition(succId, property));
    }

    @Override
    public void setTransition(int stateId, I input, int succId, TP property) {
        this.setTransition(stateId, input, this.createTransition(succId, property));
    }

    @Override
    public void setTransition(Integer state, I input, T transition) {
        this.setTransition(AbstractCompactDeterministic.getId(state), (I)this.alphabet.getSymbolIndex(input), transition);
    }

    @Override
    public abstract T createTransition(int var1, TP var2);

    @Override
    public T createTransition(Integer succ, TP property) {
        return this.createTransition(AbstractCompactDeterministic.getId(succ), property);
    }

    @Override
    public T copyTransition(T trans, Integer succ) {
        return this.copyTransition(trans, AbstractCompactDeterministic.getId(succ));
    }

    @Override
    public abstract T copyTransition(T var1, int var2);

    @Override
    public final Integer getSuccessor(T transition) {
        return AbstractCompactDeterministic.makeId(this.getIntSuccessor(transition));
    }

    @Override
    public Collection<Integer> getStates() {
        return CollectionsUtil.intRange(0, this.numStates);
    }

    @Override
    public Integer getState(int id) {
        return id;
    }

    @Override
    public int getStateId(Integer state) {
        return state;
    }

    @Override
    public int getIntInitialState() {
        return this.initial;
    }

    @Override
    public Integer getInitialState() {
        return AbstractCompactDeterministic.makeId(this.initial);
    }

    @Override
    public T getTransition(int stateId, int inputIdx) {
        return (T)this.transitions[stateId * this.alphabetSize + inputIdx];
    }

    @Override
    public T getTransition(int stateId, I input) {
        return this.getTransition(stateId, (I)this.alphabet.getSymbolIndex(input));
    }

    @Override
    public T getTransition(Integer state, I input) {
        return this.getTransition(AbstractCompactDeterministic.getId(state), (I)this.alphabet.getSymbolIndex(input));
    }

    @Override
    public abstract SP getStateProperty(int var1);

    @Override
    public SP getStateProperty(Integer state) {
        return this.getStateProperty(AbstractCompactDeterministic.getId(state));
    }

    @Override
    public void clear() {
        int endIdx = this.numStates * this.alphabetSize;
        this.numStates = 0;
        for (int i = 0; i < endIdx; ++i) {
            this.transitions[i] = null;
        }
        this.initial = -1;
    }

    protected final int createState() {
        int newState = this.numStates++;
        this.ensureCapacity(this.numStates);
        return newState;
    }

    @Override
    public int addIntInitialState(SP property) {
        int newState = this.addIntState(property);
        this.setInitialState(newState);
        return newState;
    }

    @Override
    public int addIntInitialState() {
        return this.addIntInitialState(null);
    }

    @Override
    public int addIntState() {
        return this.addIntState(null);
    }

    @Override
    public int addIntState(SP property) {
        int newState = this.createState();
        this.setStateProperty(newState, property);
        return newState;
    }

    @Override
    public Integer addState(SP property) {
        return this.addIntState(property);
    }

    @Override
    public abstract void setStateProperty(int var1, SP var2);

    @Override
    public void setStateProperty(Integer state, SP property) {
        this.setStateProperty((int)state, property);
    }

    @Override
    public void removeAllTransitions(Integer state) {
        int base = state * this.alphabetSize;
        for (int i = 0; i < this.alphabetSize; ++i) {
            this.transitions[base++] = null;
        }
    }

    @Override
    public StateIDs<Integer> stateIDs() {
        return this;
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public MutableDeterministic.StateIntAbstraction<I, T, SP, TP> stateIntAbstraction() {
        return this;
    }

    @Override
    public MutableDeterministic.FullIntAbstraction<T, SP, TP> fullIntAbstraction(Alphabet<I> alphabet) {
        if (alphabet == this.alphabet) {
            return this;
        }
        return MutableDeterministic.super.fullIntAbstraction((Alphabet)alphabet);
    }

    public MutableDeterministic.FullIntAbstraction<T, SP, TP> fullIntAbstraction() {
        return this;
    }

    @Override
    public int numInputs() {
        return this.alphabet.size();
    }
}

