/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Alphabet;

public abstract class AbstractCompactSimpleDet<I, SP>
implements MutableDeterministic<Integer, I, Integer, SP, Void>,
UniversalFiniteAlphabetAutomaton<Integer, I, Integer, SP, Void>,
StateIDs<Integer>,
MutableDeterministic.StateIntAbstraction<I, Integer, SP, Void>,
MutableDeterministic.FullIntAbstraction<Integer, SP, Void> {
    public static final float DEFAULT_RESIZE_FACTOR = 1.5f;
    public static final int DEFAULT_INIT_CAPACITY = 11;
    protected final Alphabet<I> alphabet;
    protected final int alphabetSize;
    protected int[] transitions;
    protected int stateCapacity;
    protected int numStates;
    protected int initial = -1;
    protected final float resizeFactor;

    public AbstractCompactSimpleDet(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public AbstractCompactSimpleDet(Alphabet<I> alphabet, int stateCapacity) {
        this(alphabet, stateCapacity, 1.5f);
    }

    public AbstractCompactSimpleDet(Alphabet<I> alphabet, float resizeFactor) {
        this(alphabet, 11, resizeFactor);
    }

    public AbstractCompactSimpleDet(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
        this.transitions = new int[stateCapacity * this.alphabetSize];
        Arrays.fill(this.transitions, 0, this.transitions.length, -1);
        this.resizeFactor = resizeFactor;
        this.stateCapacity = stateCapacity;
    }

    protected AbstractCompactSimpleDet(Alphabet<I> alphabet, int numStates, int initial, int[] transitions, float resizeFactor) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
        this.numStates = numStates;
        if (initial < 0 || initial >= numStates) {
            throw new IllegalArgumentException("Invalid initial state " + initial + " for automaton with " + numStates + " states");
        }
        this.initial = initial;
        if (transitions.length < numStates * this.alphabetSize) {
            throw new IllegalArgumentException("Transition array is not large enough for automaton with " + numStates + " states");
        }
        this.transitions = transitions;
        this.stateCapacity = transitions.length / this.alphabetSize;
        this.resizeFactor = resizeFactor;
    }

    protected AbstractCompactSimpleDet(Alphabet<I> alphabet, AbstractCompactSimpleDet<?, ?> other) {
        this(alphabet, other.numStates, other.initial, (int[])other.transitions.clone(), other.resizeFactor);
    }

    public void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.stateCapacity) {
            return;
        }
        int newCap = (int)((float)this.stateCapacity * this.resizeFactor);
        if (newCap < newCapacity) {
            newCap = newCapacity;
        }
        int[] newTrans = new int[newCap * this.alphabetSize];
        System.arraycopy(this.transitions, 0, newTrans, 0, this.stateCapacity * this.alphabetSize);
        Arrays.fill(newTrans, this.transitions.length, newTrans.length, -1);
        this.transitions = newTrans;
        this.ensureCapacity(this.stateCapacity, newCap);
        this.stateCapacity = newCap;
    }

    protected void ensureCapacity(int oldCap, int newCap) {
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public int size() {
        return this.numStates;
    }

    @Override
    public Collection<Integer> getStates() {
        return CollectionsUtil.intRange(0, this.numStates);
    }

    @Override
    public Integer getState(int id) {
        return id;
    }

    @Override
    public int getStateId(Integer state) {
        return state;
    }

    @Override
    public Integer getInitialState() {
        return AbstractCompactSimpleDet.wrapState(this.initial);
    }

    @Override
    public int getIntInitialState() {
        return this.initial;
    }

    @Override
    public Integer getTransition(Integer state, I input) {
        int trans = this.getIntTransition((int)state, input);
        return AbstractCompactSimpleDet.wrapState(trans);
    }

    public int getIntTransition(int state, int input) {
        int transId = state * this.alphabetSize + input;
        return this.transitions[transId];
    }

    public int getIntTransition(int state, I input) {
        return this.getIntTransition(state, this.alphabet.getSymbolIndex(input));
    }

    @Override
    public void setInitialState(int state) {
        this.initial = state;
    }

    @Override
    public void setInitialState(Integer state) {
        this.setInitialState(state != null ? state : -1);
    }

    @Override
    public void setTransition(int state, int inputIdx, int succ) {
        this.transitions[state * this.alphabetSize + inputIdx] = succ;
    }

    @Override
    public void setTransition(int state, I input, int succ) {
        this.setTransition(state, this.alphabet.getSymbolIndex(input), succ);
    }

    @Override
    public void setTransition(Integer state, I input, Integer transition) {
        int succId = transition != null ? transition : -1;
        this.setTransition((int)state, input, succId);
    }

    @Override
    public void setTransition(Integer state, I input, Integer transition, Void property) {
        this.setTransition(state, input, transition);
    }

    @Override
    public void clear() {
        int endIdx = this.numStates * this.alphabetSize;
        this.numStates = 0;
        Arrays.fill(this.transitions, 0, endIdx, -1);
        this.initial = -1;
    }

    @Override
    public void removeAllTransitions(int state) {
        int base = state * this.alphabetSize;
        Arrays.fill(this.transitions, base, base + this.alphabetSize, -1);
    }

    @Override
    public void removeAllTransitions(Integer state) {
        this.removeAllTransitions((int)state);
    }

    @Override
    public Integer copyTransition(Integer trans, Integer succ) {
        return succ;
    }

    @Override
    public Integer getSuccessor(Integer transition) {
        return transition;
    }

    public int getIntSuccessor(int state, I input) {
        return this.getIntTransition(state, input);
    }

    @Override
    public int getSuccessor(int state, I input) {
        return this.getIntTransition(state, input);
    }

    @Override
    public abstract SP getStateProperty(int var1);

    @Override
    public SP getStateProperty(Integer state) {
        return this.getStateProperty((int)state);
    }

    @Override
    public Void getTransitionProperty(Integer transition) {
        return null;
    }

    protected abstract void initState(int var1, SP var2);

    @Override
    public int addIntState(SP property) {
        int stateId = this.numStates++;
        this.ensureCapacity(this.numStates);
        this.initState(stateId, property);
        return stateId;
    }

    @Override
    public int addIntState() {
        return this.addIntState(null);
    }

    @Override
    public int addIntInitialState(SP property) {
        int state = this.addIntState(property);
        this.setInitialState(state);
        return state;
    }

    @Override
    public int addIntInitialState() {
        return this.addIntInitialState(null);
    }

    @Override
    public Integer addState(SP property) {
        return this.addIntState(property);
    }

    @Override
    public abstract void setStateProperty(int var1, SP var2);

    @Override
    public void setStateProperty(Integer state, SP property) {
        this.setStateProperty((int)state, property);
    }

    @Override
    public void setTransitionProperty(Integer transition, Void property) {
    }

    @Override
    public Integer createTransition(Integer successor, Void properties) {
        return successor;
    }

    @Override
    public Integer createTransition(int successor, Void property) {
        return AbstractCompactSimpleDet.wrapState(successor);
    }

    @Override
    public StateIDs<Integer> stateIDs() {
        return this;
    }

    public int getIntSuccessor(int state, Iterable<? extends I> input) {
        int current = state;
        Iterator<I> inputIt = input.iterator();
        while (current >= 0 && inputIt.hasNext()) {
            current = this.getIntSuccessor(current, inputIt.next());
        }
        return current;
    }

    @Override
    public Integer getSuccessor(Integer state, Iterable<? extends I> input) {
        return AbstractCompactSimpleDet.wrapState(this.getIntSuccessor((int)state, input));
    }

    public int getIntState(Iterable<? extends I> input) {
        return this.getIntSuccessor(this.initial, input);
    }

    @Override
    public Integer getState(Iterable<? extends I> input) {
        return AbstractCompactSimpleDet.wrapState(this.getIntState(input));
    }

    @Override
    public MutableDeterministic.StateIntAbstraction<I, Integer, SP, Void> stateIntAbstraction() {
        return this;
    }

    @Override
    public MutableDeterministic.FullIntAbstraction<Integer, SP, Void> fullIntAbstraction(Alphabet<I> alphabet) {
        if (alphabet == this.alphabet) {
            return this;
        }
        return MutableDeterministic.super.fullIntAbstraction((Alphabet)alphabet);
    }

    public MutableDeterministic.FullIntAbstraction<Integer, SP, Void> fullIntAbstraction() {
        return this;
    }

    @Override
    public int getIntSuccessor(Integer transition) {
        return AbstractCompactSimpleDet.unwrapState(transition);
    }

    @Override
    public Integer getTransition(int state, I input) {
        return AbstractCompactSimpleDet.wrapState(this.getSuccessor(state, input));
    }

    @Override
    public Integer getTransition(int state, int input) {
        return AbstractCompactSimpleDet.wrapState(this.getSuccessor(state, input));
    }

    @Override
    public int getSuccessor(int state, int input) {
        return this.getIntTransition(state, input);
    }

    @Override
    public void setTransition(int state, int input, Integer transition) {
        this.setTransition(state, input, AbstractCompactSimpleDet.unwrapState(transition));
    }

    @Override
    public void setTransition(int state, int input, int successor, Void property) {
        this.setTransition(state, input, successor);
    }

    @Override
    public void setTransition(int state, I input, Integer transition) {
        this.setTransition(state, input, AbstractCompactSimpleDet.unwrapState(transition));
    }

    @Override
    public void setTransition(int state, I input, int successor, Void property) {
        this.setTransition(state, input, successor);
    }

    @Override
    public int numInputs() {
        return this.alphabet.size();
    }

    protected static Integer wrapState(int id) {
        if (id < 0) {
            return null;
        }
        return id;
    }

    protected static int unwrapState(Integer state) {
        if (state == null) {
            return -1;
        }
        return state;
    }
}

