/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Alphabet;

public abstract class AbstractCompactSimpleNondet<I, SP>
implements MutableAutomaton<Integer, I, Integer, SP, Void>,
UniversalFiniteAlphabetAutomaton<Integer, I, Integer, SP, Void>,
StateIDs<Integer> {
    public static final float DEFAULT_RESIZE_FACTOR = 1.5f;
    public static final int DEFAULT_INIT_CAPACITY = 11;
    protected final Alphabet<I> alphabet;
    protected final int alphabetSize;
    protected Set<Integer>[] transitions;
    protected int stateCapacity;
    protected int numStates;
    protected final Set<Integer> initial;
    private final float resizeFactor;

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet, int stateCapacity) {
        this(alphabet, stateCapacity, 1.5f);
    }

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet, float resizeFactor) {
        this(alphabet, 11, resizeFactor);
    }

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
        this.transitions = new Set[stateCapacity * this.alphabetSize];
        this.resizeFactor = resizeFactor;
        this.stateCapacity = stateCapacity;
        this.initial = new HashSet<Integer>();
    }

    protected AbstractCompactSimpleNondet(Alphabet<I> alphabet, AbstractCompactSimpleNondet<?, ?> other) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
        this.transitions = (Set[])other.transitions.clone();
        for (int i = 0; i < this.transitions.length; ++i) {
            Set<Integer> tgts = this.transitions[i];
            if (tgts == null) continue;
            this.transitions[i] = new HashSet<Integer>(tgts);
        }
        this.numStates = other.numStates;
        this.resizeFactor = other.resizeFactor;
        this.stateCapacity = other.stateCapacity;
        this.initial = new HashSet<Integer>();
    }

    public void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.stateCapacity) {
            return;
        }
        int newCap = (int)((float)this.stateCapacity * this.resizeFactor);
        if (newCap < newCapacity) {
            newCap = newCapacity;
        }
        Set[] newTrans = new Set[newCap * this.alphabetSize];
        System.arraycopy(this.transitions, 0, newTrans, 0, this.stateCapacity * this.alphabetSize);
        this.transitions = newTrans;
        this.ensureCapacity(this.stateCapacity, newCap);
        this.stateCapacity = newCap;
    }

    protected void ensureCapacity(int oldCap, int newCap) {
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public int size() {
        return this.numStates;
    }

    @Override
    public Collection<Integer> getStates() {
        return CollectionsUtil.intRange(0, this.numStates);
    }

    @Override
    public Integer getState(int id) {
        return id;
    }

    @Override
    public int getStateId(Integer state) {
        return state;
    }

    public Set<Integer> getIntInitialStates() {
        return this.initial;
    }

    public Set<Integer> getIntTransitions(int state, I input) {
        int transId = state * this.alphabetSize + this.alphabet.getSymbolIndex(input);
        return this.successors(transId);
    }

    @Override
    public void removeAllTransitions(int state) {
        int base = state * this.alphabetSize;
        Arrays.fill(this.transitions, base, base + this.alphabetSize, null);
    }

    @Override
    public void removeTransition(Integer state, I input, Integer transition) {
        this.removeTransition((int)state, input, (int)transition);
    }

    @Override
    public void removeTransition(int stateId, I input, int successorId) {
        this.removeTransition(stateId, this.alphabet.getSymbolIndex(input), successorId);
    }

    @Override
    public void removeTransition(int stateId, int inputIdx, int successorId) {
        int transIdx = stateId * this.alphabetSize + inputIdx;
        Set<Integer> successors = this.transitions[transIdx];
        if (successors != null) {
            successors.remove(successorId);
        }
    }

    @Override
    public void removeAllTransitions(Integer state, I input) {
        this.removeAllTransitions((int)state, input);
    }

    @Override
    public void removeAllTransitions(int stateId, I input) {
        this.removeAllTransitions(stateId, this.alphabet.getSymbolIndex(input));
    }

    @Override
    public void removeAllTransitions(int stateId, int inputIdx) {
        int transIdx = stateId * this.alphabetSize + inputIdx;
        this.transitions[transIdx] = null;
    }

    @Override
    public void addTransition(Integer state, I input, Integer transition) {
        this.addTransition((int)state, input, (int)transition);
    }

    @Override
    public void addTransition(int stateId, I input, int succId) {
        this.addTransition(stateId, this.alphabet.getSymbolIndex(input), succId);
    }

    @Override
    public void addTransition(int stateId, int inputIdx, int succId) {
        int transIdx = stateId * this.alphabetSize + inputIdx;
        Set<Integer> successors = this.transitions[transIdx];
        if (successors == null) {
            this.transitions[transIdx] = successors = new HashSet<Integer>();
        }
        successors.add(succId);
    }

    @Override
    public void removeAllTransitions(Integer state) {
        this.removeAllTransitions((int)state);
    }

    @Override
    public Integer copyTransition(Integer trans, Integer succ) {
        return succ;
    }

    @Override
    public Integer getSuccessor(Integer transition) {
        return transition;
    }

    @Override
    public abstract SP getStateProperty(int var1);

    @Override
    public SP getStateProperty(Integer state) {
        return this.getStateProperty((int)state);
    }

    @Override
    public Void getTransitionProperty(Integer transition) {
        return null;
    }

    protected abstract void initState(int var1, SP var2);

    public int addIntState(SP property) {
        int stateId = this.numStates++;
        this.ensureCapacity(this.numStates);
        this.initState(stateId, property);
        return stateId;
    }

    public int addIntState() {
        return this.addIntState(null);
    }

    public int addIntInitialState(SP property) {
        int state = this.addIntState(property);
        this.setInitial(state, true);
        return state;
    }

    public int addIntInitialState() {
        return this.addIntInitialState(null);
    }

    @Override
    public Integer addState(SP property) {
        return this.addIntState(property);
    }

    @Override
    public abstract void setStateProperty(int var1, SP var2);

    @Override
    public void setStateProperty(Integer state, SP property) {
        this.setStateProperty((int)state, property);
    }

    @Override
    public void setTransitionProperty(Integer transition, Void property) {
    }

    @Override
    public Integer createTransition(Integer successor, Void properties) {
        return successor;
    }

    @Override
    public StateIDs<Integer> stateIDs() {
        return this;
    }

    protected Set<Integer> successors(int transId) {
        Set<Integer> successors = this.transitions[transId];
        if (successors == null) {
            return Collections.emptySet();
        }
        return successors;
    }

    protected static Integer wrapState(int id) {
        if (id < 0) {
            return null;
        }
        return id;
    }

    @Override
    public void clear() {
        Arrays.fill(this.transitions, 0, this.numStates * this.alphabetSize, null);
        this.numStates = 0;
        this.initial.clear();
    }

    @Override
    public void setInitial(Integer state, boolean initial) {
        this.setInitial((int)state, initial);
    }

    @Override
    public void setInitial(int state, boolean initial) {
        if (initial) {
            this.initial.add(state);
        } else {
            this.initial.remove(state);
        }
    }

    @Override
    public void setTransitions(Integer state, I input, Collection<? extends Integer> transitions) {
        ArrayList<Integer> successors = new ArrayList<Integer>(transitions.size());
        for (Integer n : transitions) {
            successors.add(n);
        }
        this.setTransitions(state, input, (Collection<? extends Integer>)successors);
    }

    @Override
    public void setTransitions(int state, I input, Collection<? extends Integer> successors) {
        this.setTransitions(state, this.alphabet.getSymbolIndex(input), successors);
    }

    @Override
    public void setTransitions(int state, int inputIdx, Collection<? extends Integer> successors) {
        int transIdx = state * this.alphabetSize + inputIdx;
        Set<Integer> succs = this.transitions[transIdx];
        if (succs == null) {
            this.transitions[transIdx] = succs = new HashSet<Integer>();
        } else {
            succs.clear();
            succs.addAll(successors);
        }
    }

    @Override
    public Collection<? extends Integer> getTransitions(Integer state, I input) {
        return this.getTransitions((int)state, input);
    }

    @Override
    public Set<Integer> getTransitions(int state, I input) {
        return this.getTransitions(state, this.alphabet.getSymbolIndex(input));
    }

    @Override
    public Set<Integer> getTransitions(int state, int inputIdx) {
        return this.successors(state * this.alphabetSize + inputIdx);
    }

    @Override
    public Set<? extends Integer> getInitialStates() {
        return this.initial;
    }
}

