/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.fast;

import java.util.Collection;
import net.automatalib.automata.ShrinkableAutomaton;
import net.automatalib.automata.ShrinkableDeterministic;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.base.StateIDDynamicMapping;
import net.automatalib.automata.base.fast.FastDetState;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.helpers.StateIDStaticMapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.nid.AbstractMutableNumericID;
import net.automatalib.commons.util.nid.DynamicList;
import net.automatalib.commons.util.nid.IDChangeNotifier;
import net.automatalib.words.Alphabet;

public abstract class FastMutableDet<S extends FastDetState<S, T>, I, T, SP, TP>
implements ShrinkableDeterministic<S, I, T, SP, TP>,
UniversalFiniteAlphabetAutomaton<S, I, T, SP, TP>,
StateIDs<S> {
    private final DynamicList<S> states = new DynamicList();
    private final IDChangeNotifier<S> tracker = new IDChangeNotifier();
    private S initialState;
    protected final Alphabet<I> inputAlphabet;

    public FastMutableDet(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
    }

    @Override
    public Collection<S> getStates() {
        return this.states;
    }

    @Override
    public S getState(int id) {
        return (S)((FastDetState)this.states.get(id));
    }

    @Override
    public int getStateId(S state) {
        return ((AbstractMutableNumericID)state).getId();
    }

    @Override
    public void setInitialState(S state) {
        this.initialState = state;
    }

    @Override
    public void setTransition(S state, I input, T transition) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        ((FastDetState)state).setTransition(inputIdx, transition);
    }

    @Override
    public S getInitialState() {
        return this.initialState;
    }

    @Override
    public T getTransition(S state, I input) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        return ((FastDetState)state).getTransition(inputIdx);
    }

    @Override
    public void clear() {
        this.states.clear();
        this.initialState = null;
    }

    @Override
    public S addState(SP property) {
        S newState = this.createState(property);
        this.states.add(newState);
        return newState;
    }

    @Override
    public void removeState(S state, S replacement) {
        ShrinkableAutomaton.unlinkState(this, state, replacement, this.inputAlphabet);
        this.states.remove(state);
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Override
    public void removeAllTransitions(S state) {
        ((FastDetState)state).clearTransitions();
    }

    @Override
    public StateIDs<S> stateIDs() {
        return this;
    }

    @Override
    public <V> MutableMapping<S, V> createStaticStateMapping() {
        return new StateIDStaticMapping(this, this.size());
    }

    @Override
    public <V> MutableMapping<S, V> createDynamicStateMapping() {
        StateIDDynamicMapping mapping = new StateIDDynamicMapping(this);
        this.tracker.addListener(mapping, true);
        return mapping;
    }

    protected abstract S createState(SP var1);
}

