/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.fast;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.automata.ShrinkableAutomaton;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.base.StateIDDynamicMapping;
import net.automatalib.automata.base.fast.FastNondetState;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.helpers.StateIDStaticMapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.nid.AbstractMutableNumericID;
import net.automatalib.commons.util.nid.DynamicList;
import net.automatalib.commons.util.nid.IDChangeNotifier;
import net.automatalib.words.Alphabet;

public abstract class FastMutableNondet<S extends FastNondetState<S, T>, I, T, SP, TP>
implements ShrinkableAutomaton<S, I, T, SP, TP>,
UniversalFiniteAlphabetAutomaton<S, I, T, SP, TP>,
StateIDs<S> {
    private final DynamicList<S> states = new DynamicList();
    private final IDChangeNotifier<S> tracker = new IDChangeNotifier();
    private final Set<S> initialStates = new HashSet<S>();
    protected Alphabet<I> inputAlphabet;

    public FastMutableNondet(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
    }

    @Override
    public Collection<S> getStates() {
        return this.states;
    }

    @Override
    public S getState(int id) {
        return (S)((FastNondetState)this.states.get(id));
    }

    @Override
    public int getStateId(S state) {
        return ((AbstractMutableNumericID)state).getId();
    }

    @Override
    public Set<S> getInitialStates() {
        return this.initialStates;
    }

    @Override
    public Collection<T> getTransitions(S state, I input) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        return ((FastNondetState)state).getTransitions(inputIdx);
    }

    @Override
    public void clear() {
        this.states.clear();
        this.initialStates.clear();
    }

    @Override
    public S addState(SP property) {
        S newState = this.createState(property);
        this.states.add(newState);
        return newState;
    }

    @Override
    public void setInitial(S state, boolean initial) {
        if (initial) {
            this.initialStates.add(state);
        } else {
            this.initialStates.remove(state);
        }
    }

    @Override
    public void removeState(S state, S replacement) {
        ShrinkableAutomaton.unlinkState(this, state, replacement, this.inputAlphabet);
        this.states.remove(state);
        if (this.initialStates.remove(state)) {
            this.initialStates.add(state);
        }
    }

    @Override
    public void removeAllTransitions(S state) {
        ((FastNondetState)state).clearTransitions();
    }

    @Override
    public void setTransitions(S state, I input, Collection<? extends T> transitions) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        ((FastNondetState)state).setTransitions(inputIdx, transitions);
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Override
    public StateIDs<S> stateIDs() {
        return this;
    }

    @Override
    public <V> MutableMapping<S, V> createStaticStateMapping() {
        return new StateIDStaticMapping(this, this.size());
    }

    @Override
    public <V> MutableMapping<S, V> createDynamicStateMapping() {
        StateIDDynamicMapping mapping = new StateIDDynamicMapping(this);
        this.tracker.addListener(mapping, true);
        return mapping;
    }

    protected abstract S createState(SP var1);
}

