/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.fsa;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.automata.UniversalAutomaton;
import net.automatalib.automata.concepts.OutputAutomaton;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.automata.dot.DOTHelperFSA;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.automata.graphs.UniversalAutomatonGraphView;
import net.automatalib.commons.util.collections.IterableUtil;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.ts.acceptors.AcceptorTS;

public interface FiniteStateAcceptor<S, I>
extends AcceptorTS<S, I>,
UniversalAutomaton<S, I, S, Boolean, Void>,
OutputAutomaton<S, I, S, Boolean>,
SuffixOutput<I, Boolean> {
    public static final List<Boolean> STATE_PROPERTIES = Arrays.asList(Boolean.FALSE, Boolean.TRUE);
    public static final List<Void> TRANSITION_PROPERTIES = Collections.singletonList(null);

    @Override
    default public Boolean computeOutput(Iterable<? extends I> input) {
        return this.accepts(input);
    }

    @Override
    default public Boolean computeSuffixOutput(Iterable<? extends I> prefix, Iterable<? extends I> suffix) {
        Iterable input = IterableUtil.concat(prefix, suffix);
        return this.computeOutput(input);
    }

    @Override
    default public UniversalGraph<S, TransitionEdge<I, S>, Boolean, TransitionEdge.Property<I, Void>> transitionGraphView(Collection<? extends I> inputs) {
        return new FSAGraphView(this, inputs);
    }

    public static class FSAGraphView<S, I, A extends FiniteStateAcceptor<S, I>>
    extends UniversalAutomatonGraphView<S, I, S, Boolean, Void, A> {
        public FSAGraphView(A automaton, Collection<? extends I> inputs) {
            super(automaton, inputs);
        }

        @Override
        public GraphDOTHelper<S, ? super TransitionEdge<I, S>> getGraphDOTHelper() {
            return new DOTHelperFSA((FiniteStateAcceptor)this.automaton);
        }
    }
}

