/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.fsa;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.automata.fsa.FiniteStateAcceptor;

@ParametersAreNonnullByDefault
public interface MutableFSA<S, I>
extends FiniteStateAcceptor<S, I>,
MutableAutomaton<S, I, S, Boolean, Void> {
    @Override
    default public void setStateProperty(S state, Boolean property) {
        boolean acc = property != null ? property : false;
        this.setAccepting(state, acc);
    }

    @Override
    default public void setTransitionProperty(S transition, Void property) {
    }

    default public void flipAcceptance() {
        for (Object state : this) {
            this.setAccepting(state, !this.isAccepting(state));
        }
    }

    @Override
    default public S addState() {
        return this.addState(false);
    }

    @Override
    default public S addState(Boolean property) {
        boolean acc = property != null ? property : false;
        return this.addState(acc);
    }

    @Override
    default public S addInitialState() {
        return this.addInitialState(false);
    }

    @Override
    default public S addInitialState(Boolean property) {
        boolean acc = property != null ? property : false;
        return this.addInitialState(acc);
    }

    @Override
    default public S createTransition(S successor, Void properties) {
        return successor;
    }

    @Override
    default public S copyTransition(S trans, S succ) {
        return succ;
    }

    @Override
    default public S addInitialState(boolean accepting) {
        S init = this.addState(accepting);
        this.setInitial(init, true);
        return init;
    }

    @Override
    @Nonnull
    public S addState(boolean var1);

    public void setAccepting(S var1, boolean var2);
}

