/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.graphs;

import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.concepts.InputAlphabetHolder;
import net.automatalib.automata.dot.DefaultDOTHelperAutomaton;
import net.automatalib.automata.graphs.AbstractAutomatonGraphView;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.graphs.dot.GraphDOTHelper;

public class AutomatonGraphView<S, I, T, A extends Automaton<S, I, T>>
extends AbstractAutomatonGraphView<S, A, TransitionEdge<I, T>> {
    protected final Collection<? extends I> inputs;

    public static <S, I, T> Collection<TransitionEdge<I, T>> createTransitionEdges(Automaton<S, I, T> automaton, Collection<? extends I> inputs, S state) {
        ArrayList<TransitionEdge<I, T>> result = new ArrayList<TransitionEdge<I, T>>();
        for (I input : inputs) {
            Collection transitions = automaton.getTransitions(state, input);
            for (Object t : transitions) {
                result.add(new TransitionEdge(input, t));
            }
        }
        return result;
    }

    public static <S, I, T, A extends Automaton<S, I, T>> AutomatonGraphView<S, I, T, A> create(A automaton, Collection<? extends I> inputs) {
        return new AutomatonGraphView<S, I, T, A>(automaton, inputs);
    }

    public static <S, I, T, A extends Automaton<S, I, T> & InputAlphabetHolder<I>> AutomatonGraphView<S, I, T, A> create(A automaton) {
        return new AutomatonGraphView<S, I, T, A>(automaton, ((InputAlphabetHolder<I>)automaton).getInputAlphabet());
    }

    public AutomatonGraphView(A automaton, Collection<? extends I> inputs) {
        super(automaton);
        this.inputs = inputs;
    }

    @Override
    public Collection<? extends TransitionEdge<I, T>> getOutgoingEdges(S node) {
        return AutomatonGraphView.createTransitionEdges(this.automaton, this.inputs, node);
    }

    @Override
    public S getTarget(TransitionEdge<I, T> edge) {
        return this.automaton.getSuccessor(edge.getTransition());
    }

    @Override
    public GraphDOTHelper<S, ? super TransitionEdge<I, T>> getGraphDOTHelper() {
        return new DefaultDOTHelperAutomaton(this.automaton);
    }
}

