/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.graphs;

import java.util.Objects;
import net.automatalib.ts.UniversalTransitionSystem;

public final class TransitionEdge<I, T> {
    private final I input;
    private final T transition;

    public TransitionEdge(I input, T transition) {
        this.input = input;
        this.transition = transition;
    }

    public I getInput() {
        return this.input;
    }

    public T getTransition() {
        return this.transition;
    }

    public <TP> Property<I, TP> property(UniversalTransitionSystem<?, ?, T, ?, TP> uts) {
        return new Property<I, TP>(this.input, uts.getTransitionProperty(this.transition));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.input);
        result = 31 * result + Objects.hashCode(this.transition);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != TransitionEdge.class) {
            return false;
        }
        TransitionEdge other = (TransitionEdge)obj;
        if (!Objects.equals(this.input, other.input)) {
            return false;
        }
        return Objects.equals(this.transition, other.transition);
    }

    public static final class Property<I, TP> {
        private final I input;
        private final TP property;

        public Property(I input, TP property) {
            this.input = input;
            this.property = property;
        }

        public I getInput() {
            return this.input;
        }

        public TP getProperty() {
            return this.property;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.input);
            result = 31 * result + Objects.hashCode(this.property);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != Property.class) {
                return false;
            }
            Property other = (Property)obj;
            if (!Objects.equals(this.input, other.input)) {
                return false;
            }
            return Objects.equals(this.property, other.property);
        }
    }
}

