/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.simple;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.helpers.SimpleStateIDs;
import net.automatalib.automata.helpers.StateIDStaticMapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.ts.simple.SimpleTS;

public interface SimpleAutomaton<S, I>
extends SimpleTS<S, I>,
Iterable<S> {
    @Nonnull
    public Collection<S> getStates();

    default public int size() {
        return this.getStates().size();
    }

    @Nonnull
    default public StateIDs<S> stateIDs() {
        return new SimpleStateIDs(this);
    }

    @Override
    @Nonnull
    default public Iterator<S> iterator() {
        return this.getStates().iterator();
    }

    @Override
    @Nonnull
    default public <V> MutableMapping<S, V> createStaticStateMapping() {
        return new StateIDStaticMapping(this.stateIDs(), this.size());
    }
}

