/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.transout.impl.map;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.automatalib.graphs.MutableGraph;
import net.automatalib.graphs.ShrinkableGraph;

public class SimpleMapGraph<N>
implements MutableGraph<N, N, N, Void>,
ShrinkableGraph<N, N> {
    @Nonnull
    private final Map<N, Collection<N>> structureMap;
    @Nonnull
    private final Supplier<? extends Collection<N>> adjCollSupplier;

    public SimpleMapGraph() {
        this(new HashMap(), HashSet::new);
    }

    public SimpleMapGraph(Supplier<? extends Collection<N>> adjCollSupplier) {
        this(new HashMap(), adjCollSupplier);
    }

    public SimpleMapGraph(Map<N, Collection<N>> structureMap) {
        this(structureMap, HashSet::new);
    }

    public SimpleMapGraph(Map<N, Collection<N>> structureMap, Supplier<? extends Collection<N>> adjCollSupplier) {
        this.structureMap = structureMap;
        this.adjCollSupplier = adjCollSupplier;
    }

    @Override
    public Collection<? extends N> getOutgoingEdges(N node) {
        return Collections.unmodifiableCollection(this.structureMap.getOrDefault(node, Collections.emptySet()));
    }

    @Override
    public N getTarget(N edge) {
        return edge;
    }

    @Override
    public Collection<? extends N> getAdjacentTargets(N node) {
        return this.getOutgoingEdges(node);
    }

    @Override
    public Iterator<N> adjacentTargetsIterator(N node) {
        return this.outgoingEdgesIterator(node);
    }

    @Override
    public Stream<N> adjacentTargetsStream(N node) {
        return this.outgoingEdgesStream(node);
    }

    @Override
    public Set<? extends N> getNodes() {
        return Collections.unmodifiableSet(this.structureMap.keySet());
    }

    @Override
    public Iterator<N> iterator() {
        return Iterators.unmodifiableIterator(this.structureMap.keySet().iterator());
    }

    @Override
    public N getNodeProperty(N node) {
        return node;
    }

    @Override
    public Void getEdgeProperty(N edge) {
        return null;
    }

    @Override
    public N addNode(N property) {
        this.structureMap.putIfAbsent(property, this.adjCollSupplier.get());
        return property;
    }

    @Override
    public N connect(N source, N target, Void property) {
        this.structureMap.get(source).add(target);
        return target;
    }

    @Override
    @Deprecated
    public void setNodeProperty(N node, N property) {
        if (!Objects.equals(node, property)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setEdgeProperty(N edge, Void property) {
    }

    @Override
    public void removeNode(N node) {
        this.structureMap.remove(node);
        this.structureMap.values().stream().forEach(a -> a.remove(node));
    }

    @Override
    public void removeNode(N node, N replacement) {
        this.structureMap.remove(node);
        this.structureMap.values().stream().forEach(a -> {
            if (a.remove(node)) {
                a.add(replacement);
            }
        });
    }

    @Override
    public void removeEdge(N node, N edge) {
        this.structureMap.get(node).remove(edge);
    }
}

