/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.brics;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.fsa.FiniteStateAcceptor;
import net.automatalib.automata.graphs.AbstractAutomatonGraphView;
import net.automatalib.brics.BricsDOTHelper;
import net.automatalib.brics.BricsTransitionProperty;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.graphs.concepts.GraphViewable;
import net.automatalib.graphs.dot.GraphDOTHelper;

@ParametersAreNonnullByDefault
public abstract class AbstractBricsAutomaton
implements FiniteStateAcceptor<State, Character>,
GraphViewable {
    protected final Automaton automaton;

    public AbstractBricsAutomaton(Automaton automaton) {
        if (automaton == null) {
            throw new IllegalArgumentException("Provided Brics automaton must not be null");
        }
        this.automaton = automaton;
    }

    public Automaton getBricsAutomaton() {
        return this.automaton;
    }

    @Override
    public boolean isAccepting(State state) {
        return state.isAccept();
    }

    @Override
    public Collection<State> getTransitions(State state, @Nonnull Character input) {
        List transitions = state.getSortedTransitions(false);
        HashSet<State> result = new HashSet<State>();
        for (Transition t : transitions) {
            char min = t.getMin();
            if (input.charValue() < min) break;
            char max = t.getMax();
            if (input.charValue() > max) continue;
            result.add(t.getDest());
        }
        return result;
    }

    @Override
    public Set<State> getInitialStates() {
        return Collections.singleton(this.automaton.getInitialState());
    }

    @Override
    public Collection<State> getStates() {
        return this.automaton.getStates();
    }

    public GraphView graphView() {
        return new GraphView();
    }

    public class GraphView
    extends AbstractAutomatonGraphView<State, AbstractBricsAutomaton, Transition>
    implements UniversalGraph<State, Transition, Boolean, BricsTransitionProperty> {
        public GraphView() {
            super(AbstractBricsAutomaton.this);
        }

        @Override
        public Collection<? extends Transition> getOutgoingEdges(State node) {
            return node.getTransitions();
        }

        @Override
        public State getTarget(Transition edge) {
            return edge.getDest();
        }

        @Override
        public GraphDOTHelper<State, Transition> getGraphDOTHelper() {
            return new BricsDOTHelper(AbstractBricsAutomaton.this);
        }

        @Override
        public Boolean getNodeProperty(State node) {
            return node.isAccept();
        }

        @Override
        public BricsTransitionProperty getEdgeProperty(Transition edge) {
            return new BricsTransitionProperty(edge);
        }
    }
}

