/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.dotutil;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import net.automatalib.commons.dotutil.DOT;

final class PlottedGraph {
    private String name;
    private String dotText;
    private BufferedImage image;

    public PlottedGraph(String name, Reader dotText) throws IOException {
        int len;
        this.name = name;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = dotText.read(buf)) != -1) {
            sb.append(buf, 0, len);
        }
        try {
            dotText.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.updateDOTText(sb.toString());
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public String getDOTText() {
        return this.dotText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDOTText(String dotText) {
        try (InputStream pngIs = DOT.runDOT(dotText, "png", new String[0]);){
            BufferedImage img;
            this.image = img = ImageIO.read(pngIs);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Failed to invoke the DOT command!", "Failure rendering graph", 0);
            return false;
        }
        this.dotText = dotText;
        return true;
    }

    public void saveDot(File file) throws IOException {
        try (FileWriter fw = new FileWriter(file);){
            fw.write(this.dotText);
        }
    }

    public void savePng(File file) throws IOException {
        ImageIO.write((RenderedImage)this.image, "png", file);
    }
}

