/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.smartcollections;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Objects;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.SmartCollection;

public abstract class AbstractSmartCollection<E>
extends AbstractCollection<E>
implements SmartCollection<E> {
    @Override
    public void addAll(Iterable<? extends E> iterable) {
        for (E e : iterable) {
            this.add(e);
        }
    }

    @Override
    public <T extends E> void addAll(T[] array) {
        for (T t : array) {
            this.add(t);
        }
    }

    @Override
    public E choose() {
        return this.iterator().next();
    }

    @Override
    public ElementReference chooseRef() {
        return this.referenceIterator().next();
    }

    @Override
    public boolean add(E e) {
        this.referencedAdd(e);
        return true;
    }

    @Override
    public Iterable<ElementReference> references() {
        return new Iterable<ElementReference>(){

            @Override
            public Iterator<ElementReference> iterator() {
                return AbstractSmartCollection.this.referenceIterator();
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return new DeRefIterator(this.referenceIterator());
    }

    @Override
    public ElementReference find(Object element) {
        for (ElementReference ref : this.references()) {
            Object current = this.get(ref);
            if (!Objects.equals(current, element)) continue;
            return ref;
        }
        return null;
    }

    @Override
    public boolean remove(Object element) {
        ElementReference ref = this.find(element);
        if (ref == null) {
            return false;
        }
        this.remove(ref);
        return true;
    }

    @Override
    public void deepClear() {
        this.clear();
    }

    @Override
    public void quickClear() {
        this.clear();
    }

    private class DeRefIterator
    implements Iterator<E> {
        private Iterator<ElementReference> refIterator;

        public DeRefIterator(Iterator<ElementReference> refIterator) {
            this.refIterator = refIterator;
        }

        @Override
        public boolean hasNext() {
            return this.refIterator.hasNext();
        }

        @Override
        public E next() {
            return AbstractSmartCollection.this.get(this.refIterator.next());
        }

        @Override
        public void remove() {
            this.refIterator.remove();
        }
    }
}

