/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPInputStream;

public abstract class IOUtil {
    public static void skip(InputStream is) throws IOException {
        while (is.available() > 0) {
            is.skip(Long.MAX_VALUE);
        }
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, OutputStream os, boolean close) throws IOException {
        byte[] buf = new byte[8192];
        try {
            int len;
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        }
        finally {
            if (close) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        IOUtil.copy(is, os, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader r, Writer w, boolean close) throws IOException {
        char[] buf = new char[8192];
        try {
            int len;
            while ((len = r.read(buf)) != -1) {
                w.write(buf, 0, len);
            }
        }
        finally {
            if (close) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
                try {
                    w.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void copy(Reader r, Writer w) throws IOException {
        IOUtil.copy(r, w, true);
    }

    public static InputStream asBufferedInputStream(InputStream is) {
        if (is instanceof BufferedInputStream || is instanceof ByteArrayInputStream) {
            return is;
        }
        return new BufferedInputStream(is);
    }

    public static InputStream asUncompressedInputStream(InputStream is) throws IOException {
        int magic;
        is = IOUtil.asBufferedInputStream(is);
        assert (is.markSupported());
        is.mark(2);
        byte[] buf = new byte[2];
        int bytesRead = 0;
        try {
            bytesRead = is.read(buf);
        }
        finally {
            is.reset();
        }
        if (bytesRead == 2 && (magic = (buf[1] & 0xFF) << 8 | buf[0] & 0xFF) == 35615) {
            return new GZIPInputStream(is);
        }
        return is;
    }

    public static OutputStream asBufferedOutputStream(OutputStream os) {
        if (os instanceof BufferedOutputStream || os instanceof ByteArrayOutputStream) {
            return os;
        }
        return new BufferedOutputStream(os);
    }
}

