/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class ReflectUtil {
    private static final Class<?>[][] W2P_MAPPING = new Class[][]{{Void.class, Void.TYPE}, {Boolean.class, Boolean.TYPE}, {Byte.class, Byte.TYPE}, {Character.class, Character.TYPE}, {Short.class, Short.TYPE}, {Integer.class, Integer.TYPE}, {Long.class, Long.TYPE}, {Float.class, Float.TYPE}, {Double.class, Double.TYPE}};
    private static final Map<Class<?>, Class<?>> w2pMap = new HashMap();

    private ReflectUtil() {
    }

    public static Class<?> wrapperToPrimitive(Class<?> wrapperClazz) {
        Class<?> prim = w2pMap.get(wrapperClazz);
        if (prim == null) {
            return wrapperClazz;
        }
        return prim;
    }

    public static Class<?>[] wrapperToPrimitive(Class<?> ... clazzes) {
        Class<?>[] result = clazzes;
        for (int i = 0; i < result.length; ++i) {
            Class<?> curr = result[i];
            Class<?> prim = ReflectUtil.wrapperToPrimitive(curr);
            if (prim == curr) continue;
            if (result == clazzes) {
                result = (Class[])clazzes.clone();
            }
            result[i] = prim;
        }
        return result;
    }

    public static boolean w2pEquals(Class<?> a, Class<?> b) {
        a = ReflectUtil.wrapperToPrimitive(a);
        b = ReflectUtil.wrapperToPrimitive(b);
        return a.equals(b);
    }

    public static boolean w2pEquals(Class<?>[] a, Class<?> ... b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (ReflectUtil.w2pEquals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, Class<?> ... params) throws SecurityException, NoSuchMethodException {
        try {
            return clazz.getConstructor(params);
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] ctors;
            Class<?>[] primParams = ReflectUtil.wrapperToPrimitive(params);
            if (primParams != params) {
                try {
                    return clazz.getConstructor(primParams);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            for (Constructor<?> candidate : ctors = clazz.getConstructors()) {
                if (!ReflectUtil.w2pEquals(candidate.getParameterTypes(), params)) continue;
                return candidate;
            }
            throw e;
        }
    }

    public static Method findMatchingMethod(Class<?> clazz, String name, Object ... args) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(name) || !ReflectUtil.isMatch(m.getParameterTypes(), args)) continue;
            return m;
        }
        return null;
    }

    public static boolean isMatch(Class<?>[] paramTypes, Object ... args) {
        if (paramTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> argType;
            Class<?> paramType = paramTypes[i];
            Object arg = args[i];
            if (paramType.isPrimitive()) {
                if (arg == null) {
                    return false;
                }
                argType = arg.getClass();
                if (paramType == ReflectUtil.wrapperToPrimitive(argType)) continue;
                return false;
            }
            if (arg == null || paramType.isAssignableFrom(argType = arg.getClass())) continue;
            return false;
        }
        return true;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... params) throws SecurityException, NoSuchMethodException {
        try {
            return clazz.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            Method[] methods;
            Class<?>[] primParams = ReflectUtil.wrapperToPrimitive(params);
            if (primParams != params) {
                try {
                    return clazz.getMethod(name, primParams);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            for (Method candidate : methods = clazz.getMethods()) {
                if (!ReflectUtil.w2pEquals(candidate.getParameterTypes(), new Class[0])) continue;
                return candidate;
            }
            throw e;
        }
    }

    public static Method findMethodRT(Class<?> clazz, String name, Class<?> returnType, Class<?> ... params) throws SecurityException, NoSuchMethodException {
        Method m = ReflectUtil.findMethod(clazz, name, params);
        if (returnType == null) {
            return m;
        }
        Class<?> rt = m.getReturnType();
        if (ReflectUtil.w2pEquals(rt, returnType) || returnType.isAssignableFrom(rt)) {
            return m;
        }
        throw new NoSuchMethodException("Method with matching parameters but incompatible return type " + rt.getName() + " (expected " + returnType.getName() + ") found");
    }

    static {
        for (Class<?>[] w2p : W2P_MAPPING) {
            w2pMap.put(w2p[0], w2p[1]);
        }
    }
}

