/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

import net.automatalib.commons.util.IntDisjointSets;

public class UnionFindRemSP
implements IntDisjointSets {
    private final int[] p;

    public UnionFindRemSP(int n) {
        this.p = new int[n];
        for (int i = 0; i < n; ++i) {
            this.p[i] = i;
        }
    }

    @Override
    public int size() {
        return this.p.length;
    }

    @Override
    public boolean union(int x, int y) {
        int rx = x;
        int ry = y;
        int px = this.p[rx];
        int py = this.p[ry];
        while (px != py) {
            if (px < py) {
                if (rx == px) {
                    this.p[rx] = py;
                    return true;
                }
                this.p[rx] = py;
                rx = px;
                px = this.p[rx];
                continue;
            }
            if (ry == py) {
                this.p[ry] = px;
                return true;
            }
            this.p[ry] = px;
            ry = py;
            py = this.p[ry];
        }
        return false;
    }

    @Override
    public int link(int x, int y) {
        if (x < y) {
            this.p[x] = y;
            return y;
        }
        this.p[y] = x;
        return x;
    }

    @Override
    public int find(int x) {
        int curr = x;
        int currp = this.p[curr];
        while (curr != currp) {
            curr = currp;
            currp = this.p[curr];
        }
        return curr;
    }

    @Override
    public boolean equivalent(int x, int y) {
        int rx = x;
        int ry = y;
        int px = this.p[rx];
        int py = this.p[ry];
        while (px != py) {
            if (px < py) {
                if (rx == px) {
                    return false;
                }
                rx = px;
                px = this.p[rx];
                continue;
            }
            if (ry == py) {
                return false;
            }
            ry = py;
            py = this.p[ry];
        }
        return true;
    }
}

