/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

final class AllTuplesIterator<T>
implements Iterator<List<T>> {
    private final Iterable<T> iterable;
    private final List<T> current;
    private final Iterator<T>[] iterators;
    private boolean firstEmpty;

    public AllTuplesIterator(Iterable<T> iterable, int minLength, int maxLength) {
        if (maxLength < minLength || minLength < 0) {
            throw new IllegalArgumentException();
        }
        this.current = new ArrayList<T>(maxLength);
        this.iterators = new Iterator[maxLength];
        this.iterable = iterable;
        for (int i = 1; i < minLength; ++i) {
            Iterator<T> it = iterable.iterator();
            this.iterators[i] = it;
            this.current.add(it.next());
        }
        this.firstEmpty = minLength == 0;
    }

    @Override
    public boolean hasNext() {
        if (this.firstEmpty) {
            return true;
        }
        for (int i = 0; i < this.iterators.length; ++i) {
            Iterator<T> it = this.iterators[i];
            if (it != null && !it.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> next() {
        if (this.firstEmpty) {
            this.firstEmpty = false;
            return this.current;
        }
        for (int i = 0; i < this.iterators.length; ++i) {
            Iterator<T> it = this.iterators[i];
            if (it == null) {
                it = this.iterable.iterator();
                this.iterators[i] = it;
                this.current.add(it.next());
                return this.current;
            }
            if (this.iterators[i].hasNext()) {
                this.current.set(i, it.next());
                return this.current;
            }
            it = this.iterable.iterator();
            this.iterators[i] = it;
            this.current.set(i, it.next());
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

