/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ConcatIterator<T>
implements Iterator<T> {
    private final Iterator<? extends T>[] iterators;
    private int currentIndex;

    @SafeVarargs
    public ConcatIterator(Iterator<? extends T> ... iterators) {
        Iterator<T> it;
        int i;
        int numIts = iterators.length;
        for (i = 0; i < numIts && !(it = iterators[i]).hasNext(); ++i) {
        }
        if (i == numIts) {
            this.iterators = null;
            this.currentIndex = -1;
        } else {
            this.iterators = iterators;
            this.currentIndex = i;
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterators != null && this.currentIndex < this.iterators.length;
    }

    @Override
    public T next() {
        if (this.iterators == null || this.currentIndex >= this.iterators.length) {
            throw new NoSuchElementException();
        }
        Iterator<T> curr = this.iterators[this.currentIndex];
        T nxt = curr.next();
        if (!curr.hasNext()) {
            while (++this.currentIndex < this.iterators.length && !this.iterators[this.currentIndex].hasNext()) {
            }
        }
        return nxt;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

