/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.comparison;

import java.util.Comparator;
import net.automatalib.commons.util.comparison.CmpUtil;

final class SafeComparator<T>
implements Comparator<T> {
    private final int firstNullResult;
    private final Comparator<T> baseComparator;

    public SafeComparator(Comparator<T> baseComparator, CmpUtil.NullOrdering nullOrdering) {
        this.firstNullResult = nullOrdering.firstNullResult;
        this.baseComparator = baseComparator;
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return this.firstNullResult;
        }
        if (o2 == null) {
            return -this.firstNullResult;
        }
        return this.baseComparator.compare(o1, o2);
    }
}

