/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.mappings;

import net.automatalib.commons.util.array.ResizingObjectArray;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.nid.IDChangeListener;
import net.automatalib.commons.util.nid.NumericID;

public final class ArrayMapping<K extends NumericID, V>
implements MutableMapping<K, V>,
IDChangeListener<K> {
    private final ResizingObjectArray storage;

    public ArrayMapping() {
        this.storage = new ResizingObjectArray();
    }

    public ArrayMapping(int initialSize) {
        this.storage = new ResizingObjectArray(initialSize);
    }

    @Override
    public V get(K elem) {
        int id = elem.getId();
        if (id >= this.storage.array.length) {
            return null;
        }
        return (V)this.storage.array[id];
    }

    @Override
    public V put(K key, V value) {
        int id = key.getId();
        this.storage.ensureCapacity(id + 1);
        Object old = this.storage.array[id];
        this.storage.array[id] = value;
        return (V)old;
    }

    @Override
    public void idChanged(K obj, int newId, int oldId) {
        if (newId == -1) {
            if (oldId < this.storage.array.length) {
                this.storage.array[oldId] = null;
            }
            return;
        }
        Object oldVal = null;
        if (oldId < this.storage.array.length) {
            this.storage.array[oldId] = oldVal = this.storage.array[oldId];
        }
        this.storage.ensureCapacity(newId + 1);
        this.storage.array[newId] = oldVal;
    }
}

