/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.settings;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import net.automatalib.commons.util.settings.SettingsSource;

public abstract class ClassPathFileSource
implements SettingsSource {
    private final String fileName;

    protected ClassPathFileSource(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void loadSettings(Properties properties) {
        Logger log = Logger.getLogger(this.getClass().getName());
        try {
            Enumeration<URL> resourceUrls = this.getClass().getClassLoader().getResources(this.fileName);
            while (resourceUrls.hasMoreElements()) {
                URL url = resourceUrls.nextElement();
                try {
                    BufferedInputStream is = new BufferedInputStream(url.openStream());
                    Throwable throwable = null;
                    try {
                        properties.load(is);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (IOException ex) {
                    log.severe("Could not read property file " + url + ": " + ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            log.severe("Could not enumerate " + this.fileName + " files: " + ex.getMessage());
        }
    }
}

