/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.strings;

import java.io.IOException;
import java.util.regex.Pattern;
import net.automatalib.commons.util.strings.Printable;

public abstract class StringUtil {
    private static final String IDENTIFIER_REGEX = "[a-zA-Z_]\\w*";
    private static Pattern identifierPattern = null;

    private StringUtil() {
    }

    public static Pattern getIdentifierPattern() {
        if (identifierPattern == null) {
            identifierPattern = Pattern.compile(IDENTIFIER_REGEX);
        }
        return identifierPattern;
    }

    public static String enquote(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 2);
        try {
            StringUtil.enquote(s, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void enquote(String s, Appendable a) throws IOException {
        a.append('\"');
        StringUtil.escapeQuotes(s, a);
        a.append('\"');
    }

    public static String enquoteIfNecessary(String s) {
        StringBuilder sb = new StringBuilder();
        try {
            StringUtil.enquoteIfNecessary(s, sb);
            return sb.toString();
        }
        catch (IOException ex) {
            throw new AssertionError();
        }
    }

    public static String enquoteIfNecessary(String s, Pattern p) {
        StringBuilder sb = new StringBuilder();
        try {
            StringUtil.enquoteIfNecessary(s, sb, p);
            return sb.toString();
        }
        catch (IOException ex) {
            throw new AssertionError();
        }
    }

    public static void enquoteIfNecessary(String s, Appendable a) throws IOException {
        if (!StringUtil.getIdentifierPattern().matcher(s).matches()) {
            StringUtil.enquote(s, a);
        } else {
            a.append(s);
        }
    }

    public static void enquoteIfNecessary(String s, Appendable a, Pattern valid) throws IOException {
        if (!valid.matcher(s).matches()) {
            StringUtil.enquote(s, a);
        } else {
            a.append(s);
        }
    }

    public static void enquoteIfNecessary(String s, Appendable a, Pattern valid, Pattern exception) throws IOException {
        if (!valid.matcher(s).matches() || exception.matcher(s).matches()) {
            StringUtil.enquote(s, a);
        } else {
            a.append(s);
        }
    }

    public static String unquote(String s) {
        StringBuilder sb = new StringBuilder(s.length() - 2);
        try {
            StringUtil.unquote(s, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void unquote(String s, Appendable a) throws IOException {
        if (s.charAt(0) != '\"' || s.charAt(s.length() - 1) != '\"') {
            throw new IllegalArgumentException("Argument to StringUtil.unquote() must begin and end with a double quote ('\"').");
        }
        StringUtil.unescapeQuotes(s.substring(1, s.length() - 1));
    }

    public static String unescapeQuotes(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        try {
            StringUtil.unescapeQuotes(s, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void unescapeQuotes(String s, Appendable a) throws IOException {
        int eos = s.length() - 1;
        for (int i = 0; i < eos; ++i) {
            char c = s.charAt(i);
            if (c == '\\' && (c = s.charAt(++i)) != '\"' && c != '\\') {
                a.append('\\');
            }
            a.append(c);
        }
        a.append(s.charAt(eos));
    }

    public static String escapeQuotes(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        try {
            StringUtil.escapeQuotes(s, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void escapeQuotes(String s, Appendable a) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                a.append('\\');
            }
            a.append(c);
        }
    }

    public static void appendObject(Appendable a, Object obj) throws IOException {
        if (obj instanceof Printable) {
            ((Printable)obj).print(a);
        } else {
            a.append(String.valueOf(obj));
        }
    }

    public static void appendArray(Appendable a, Object[] array, String sepString) throws IOException {
        boolean first = true;
        for (Object o : array) {
            if (first) {
                first = false;
            } else {
                a.append(sepString);
            }
            StringUtil.appendObject(a, o);
        }
    }

    public static void appendArrayEnquoted(Appendable a, Object[] array, String sepString) throws IOException {
        boolean first = true;
        for (Object o : array) {
            if (first) {
                first = false;
            } else {
                a.append(sepString);
            }
            StringUtil.enquote(String.valueOf(o), a);
        }
    }

    public static void appendIterable(Appendable a, Iterable<?> it, String sepString) throws IOException {
        boolean first = true;
        for (Object o : it) {
            if (first) {
                first = false;
            } else {
                a.append(sepString);
            }
            StringUtil.appendObject(a, o);
        }
    }

    public static void appendIterableEnquoted(Appendable a, Iterable<?> it, String sepString) throws IOException {
        boolean first = true;
        for (Object o : it) {
            if (first) {
                first = false;
            } else {
                a.append(sepString);
            }
            if (o == null) {
                a.append("null");
                continue;
            }
            StringUtil.enquote(o.toString(), a);
        }
    }
}

