/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.examples.brics;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import net.automatalib.brics.BricsNFA;
import net.automatalib.commons.dotutil.DOT;
import net.automatalib.util.graphs.dot.GraphDOT;
import net.automatalib.words.Word;

public class SimpleBricsExample {
    public static void main(String[] args) throws IOException {
        RegExp r = new RegExp("ab+(c|d)*e?");
        Automaton a = r.toAutomaton();
        BricsNFA ba = new BricsNFA(a);
        Writer w = DOT.createDotWriter(true);
        GraphDOT.write(ba, w);
        w.close();
        List<Word> testWords = Arrays.asList(Word.fromString("abd"), Word.fromString("abbc"), Word.fromString("abbbbbde"), Word.fromString("ade"));
        for (Word tw : testWords) {
            System.out.println("Output for " + tw + " is " + ba.computeOutput((Iterable)tw));
        }
    }
}

