/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.examples.graph;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.automatalib.commons.dotutil.DOT;
import net.automatalib.graphs.base.compact.CompactSimpleGraph;
import net.automatalib.graphs.dot.EmptyDOTHelper;
import net.automatalib.util.graphs.dot.GraphDOT;
import net.automatalib.util.graphs.traversal.BaseDFSVisitor;
import net.automatalib.util.graphs.traversal.GraphTraversal;

public class DFSExample {
    public static void main(String[] args) throws Exception {
        CompactSimpleGraph graph = new CompactSimpleGraph();
        int n0 = graph.addIntNode();
        int n1 = graph.addIntNode();
        int n2 = graph.addIntNode();
        int n3 = graph.addIntNode();
        int n4 = graph.addIntNode();
        graph.connect(n0, n1);
        graph.connect(n0, n2);
        graph.connect(n1, n1);
        graph.connect(n1, n2);
        graph.connect(n2, n3);
        graph.connect(n3, n1);
        graph.connect(n3, n0);
        graph.connect(n0, n4);
        graph.connect(n4, n3);
        MyDFSVisitor vis = new MyDFSVisitor();
        GraphTraversal.dfs(graph, n0, vis);
        DFSResultDOTHelper helper = new DFSResultDOTHelper(vis);
        Writer w = DOT.createDotWriter(true);
        GraphDOT.write(graph, w, helper);
        w.close();
    }

    public static class DFSResultDOTHelper<N, E>
    extends EmptyDOTHelper<N, E> {
        private final Map<N, Integer> dfsNumbers;
        private final Map<E, EdgeType> edgeTypes;

        @Override
        public boolean getNodeProperties(N node, Map<String, String> properties) {
            String lbl = properties.get("label");
            Integer dfsNum = this.dfsNumbers.get(node);
            assert (dfsNum != null);
            properties.put("label", lbl + " [#" + dfsNum + "]");
            return true;
        }

        @Override
        public boolean getEdgeProperties(N src, E edge, N tgt, Map<String, String> properties) {
            EdgeType et = this.edgeTypes.get(edge);
            assert (et != null);
            properties.put("style", et.getStyle());
            return true;
        }

        public DFSResultDOTHelper(Map<N, Integer> dfsNumbers, Map<E, EdgeType> edgeTypes) {
            this.dfsNumbers = dfsNumbers;
            this.edgeTypes = edgeTypes;
        }

        public DFSResultDOTHelper(MyDFSVisitor<N, E> vis) {
            this(vis.getDfsNumbers(), vis.getEdgeTypes());
        }
    }

    public static class MyDFSVisitor<N, E>
    extends BaseDFSVisitor<N, E, Void> {
        private final Map<N, Integer> dfsNumbers = new HashMap<N, Integer>();
        private final Map<E, EdgeType> edgeTypes = new HashMap<E, EdgeType>();

        @Override
        public void explore(N node, Void data) {
            this.dfsNumbers.put(node, this.dfsNumbers.size());
        }

        @Override
        public Void treeEdge(N srcNode, Void srcData, E edge, N tgtNode) {
            this.edgeTypes.put(edge, EdgeType.TREE);
            return null;
        }

        @Override
        public void backEdge(N srcNode, Void srcData, E edge, N tgtNode, Void tgtData) {
            this.edgeTypes.put(edge, EdgeType.BACK);
        }

        @Override
        public void crossEdge(N srcNode, Void srcData, E edge, N tgtNode, Void tgtData) {
            this.edgeTypes.put(edge, EdgeType.CROSS);
        }

        @Override
        public void forwardEdge(N srcNode, Void srcData, E edge, N tgtNode, Void tgtData) {
            this.edgeTypes.put(edge, EdgeType.FORWARD);
        }

        public Map<N, Integer> getDfsNumbers() {
            return this.dfsNumbers;
        }

        public Map<E, EdgeType> getEdgeTypes() {
            return this.edgeTypes;
        }
    }

    public static enum EdgeType {
        TREE("bold"),
        FORWARD("dotted"),
        BACK("solid"),
        CROSS("dashed");

        private final String style;

        private EdgeType(String style) {
            this.style = style;
        }

        public String getStyle() {
            return this.style;
        }
    }
}

