/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.examples.incremental;

import java.io.IOException;
import java.io.Writer;
import net.automatalib.commons.dotutil.DOT;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.incremental.dfa.IncrementalDFABuilder;
import net.automatalib.incremental.dfa.dag.IncrementalDFADAGBuilder;
import net.automatalib.incremental.dfa.tree.IncrementalDFATreeBuilder;
import net.automatalib.util.graphs.dot.GraphDOT;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.Alphabets;

public class IncrementalDFAExample {
    private static final Alphabet<Character> alphabet = Alphabets.characters('a', 'c');

    public static void build(IncrementalDFABuilder<Character> incDfa) throws IOException {
        Word<Character> w1 = Word.fromString("abc");
        Word<Character> w2 = Word.fromString("ac");
        Word<Character> w3 = Word.fromString("acb");
        Word w4 = Word.epsilon();
        System.out.println("  Inserting " + w1 + " as accepted");
        incDfa.insert(w1, true);
        try (Writer w = DOT.createDotWriter(true);){
            GraphDOT.write(incDfa.asGraph(), w, new GraphDOTHelper[0]);
        }
        System.out.println("  Inserting " + w2 + " as rejected");
        incDfa.insert(w2, false);
        w = DOT.createDotWriter(true);
        var6_6 = null;
        try {
            GraphDOT.write(incDfa.asGraph(), w, new GraphDOTHelper[0]);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (w != null) {
                if (var6_6 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    w.close();
                }
            }
        }
        System.out.println("  Inserting " + w3 + " as accepted");
        incDfa.insert(w3, true);
        w = DOT.createDotWriter(true);
        var6_6 = null;
        try {
            GraphDOT.write(incDfa.asGraph(), w, new GraphDOTHelper[0]);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (w != null) {
                if (var6_6 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    w.close();
                }
            }
        }
        System.out.println("  Inserting " + w4 + " as accepted");
        incDfa.insert(w4, true);
        w = DOT.createDotWriter(true);
        var6_6 = null;
        try {
            GraphDOT.write(incDfa.asGraph(), w, new GraphDOTHelper[0]);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (w != null) {
                if (var6_6 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    w.close();
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Incremental construction using a Tree");
        IncrementalDFATreeBuilder<Character> incDfaTree = new IncrementalDFATreeBuilder<Character>(alphabet);
        IncrementalDFAExample.build(incDfaTree);
        System.out.println();
        System.out.println("Incremental construction using a DAG");
        IncrementalDFADAGBuilder<Character> incDfaDag = new IncrementalDFADAGBuilder<Character>(alphabet);
        IncrementalDFAExample.build(incDfaDag);
    }
}

