/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.examples.incremental;

import java.io.IOException;
import java.io.Writer;
import net.automatalib.commons.dotutil.DOT;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.incremental.mealy.dag.IncrementalMealyDAGBuilder;
import net.automatalib.incremental.mealy.tree.IncrementalMealyTreeBuilder;
import net.automatalib.util.graphs.dot.GraphDOT;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.Alphabets;

public class IncrementalMealyExample {
    private static final Alphabet<Character> alphabet = Alphabets.characters('a', 'c');
    private static final Word<Character> w1 = Word.fromString("abc");
    private static final Word<Character> w1o = Word.fromString("xyz");
    private static final Word<Character> w2 = Word.fromString("ac");
    private static final Word<Character> w2o = Word.fromString("xw");
    private static final Word<Character> w3 = Word.fromString("acb");
    private static final Word<Character> w3o = Word.fromString("xwu");

    public static void build(IncrementalMealyBuilder<Character, Character> incMealy) throws IOException {
        System.out.println("  Inserting " + w1 + " / " + w1o);
        incMealy.insert(w1, w1o);
        try (Writer w = DOT.createDotWriter(true);){
            GraphDOT.write(incMealy.asGraph(), w, new GraphDOTHelper[0]);
        }
        System.out.println("  Inserting " + w2 + " / " + w2o);
        incMealy.insert(w2, w2o);
        w = DOT.createDotWriter(true);
        var2_2 = null;
        try {
            GraphDOT.write(incMealy.asGraph(), w, new GraphDOTHelper[0]);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (w != null) {
                if (var2_2 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    w.close();
                }
            }
        }
        System.out.println("  Inserting " + w3 + " / " + w3o);
        incMealy.insert(w3, w3o);
        w = DOT.createDotWriter(true);
        var2_2 = null;
        try {
            GraphDOT.write(incMealy.asGraph(), w, new GraphDOTHelper[0]);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (w != null) {
                if (var2_2 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    w.close();
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Incremental construction using a tree");
        IncrementalMealyTreeBuilder<Character, Character> incMealyTree = new IncrementalMealyTreeBuilder<Character, Character>(alphabet);
        IncrementalMealyExample.build(incMealyTree);
        System.out.println();
        System.out.println("Incremental construction using a DAG");
        IncrementalMealyDAGBuilder<Character, Character> incMealyDag = new IncrementalMealyDAGBuilder<Character, Character>(alphabet);
        IncrementalMealyExample.build(incMealyDag);
    }
}

