/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.examples.incremental;

import java.io.IOException;
import java.io.Writer;
import net.automatalib.commons.dotutil.DOT;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.incremental.dfa.IncrementalDFABuilder;
import net.automatalib.incremental.dfa.dag.IncrementalPCDFADAGBuilder;
import net.automatalib.incremental.dfa.tree.IncrementalPCDFATreeBuilder;
import net.automatalib.util.graphs.dot.GraphDOT;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.Alphabets;

public class IncrementalPCDFAExample {
    private static final Alphabet<Character> alphabet = Alphabets.characters('a', 'c');

    public static void build(IncrementalDFABuilder<Character> incPcDfa) throws IOException {
        Word<Character> w1 = Word.fromString("abc");
        Word<Character> w2 = Word.fromString("acb");
        Word<Character> w3 = Word.fromString("ac");
        System.out.println("  Inserting " + w1 + " as accepted");
        incPcDfa.insert(w1, true);
        try (Writer w = DOT.createDotWriter(true);){
            GraphDOT.write(incPcDfa.asGraph(), w, new GraphDOTHelper[0]);
        }
        System.out.println("  Inserting " + w2 + " as rejected");
        incPcDfa.insert(w2, false);
        w = DOT.createDotWriter(true);
        var5_5 = null;
        try {
            GraphDOT.write(incPcDfa.asGraph(), w, new GraphDOTHelper[0]);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (w != null) {
                if (var5_5 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    w.close();
                }
            }
        }
        System.out.println("  Inserting " + w3 + " as accepted");
        incPcDfa.insert(w3, true);
        w = DOT.createDotWriter(true);
        var5_5 = null;
        try {
            GraphDOT.write(incPcDfa.asGraph(), w, new GraphDOTHelper[0]);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (w != null) {
                if (var5_5 != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    w.close();
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Incremental construction using a tree");
        IncrementalPCDFATreeBuilder<Character> incPcDfaTree = new IncrementalPCDFATreeBuilder<Character>(alphabet);
        IncrementalPCDFAExample.build(incPcDfaTree);
        System.out.println();
        System.out.println("Incremental construction using a DAG");
        IncrementalPCDFADAGBuilder<Character> incPcDfaDag = new IncrementalPCDFADAGBuilder<Character>(alphabet);
        IncrementalPCDFAExample.build(incPcDfaDag);
    }
}

