/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.graphs.IndefiniteSimpleGraph;

@ParametersAreNonnullByDefault
public interface IndefiniteGraph<N, E>
extends IndefiniteSimpleGraph<N> {
    @Override
    default public Collection<? extends N> getAdjacentTargets(N node) {
        return this.adjacentTargetsStream(node).collect(Collectors.toList());
    }

    @Override
    default public Iterator<N> adjacentTargetsIterator(N node) {
        return Iterators.transform(this.outgoingEdgesIterator(node), this::getTarget);
    }

    @Override
    default public Stream<N> adjacentTargetsStream(N node) {
        return this.outgoingEdgesStream(node).map(this::getTarget);
    }

    @Nonnull
    public Collection<? extends E> getOutgoingEdges(N var1);

    @Nonnull
    default public Iterator<E> outgoingEdgesIterator(N node) {
        return this.getOutgoingEdges(node).iterator();
    }

    @Nonnull
    default public Iterable<E> outgoingEdges(N node) {
        return () -> this.outgoingEdgesIterator(node);
    }

    @Nonnull
    default public Stream<E> outgoingEdgesStream(N node) {
        return this.getOutgoingEdges(node).stream();
    }

    @Nonnull
    public N getTarget(E var1);

    @Nonnull
    default public Collection<? extends E> getEdgesBetween(N from, N to) {
        return this.getOutgoingEdges(from).stream().filter(e -> Objects.equals(this.getTarget(e), to)).collect(Collectors.toList());
    }

    @Override
    default public IndefiniteGraph<N, E> asNormalGraph() {
        return this;
    }
}

