/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.IndefiniteSimpleGraph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.graphs.dot.EmptyDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.graphs.helpers.SimpleNodeIDs;

public interface SimpleGraph<N>
extends IndefiniteSimpleGraph<N>,
Iterable<N> {
    default public int size() {
        return this.getNodes().size();
    }

    @Override
    @Nonnull
    default public Iterator<N> iterator() {
        return Iterators.unmodifiableIterator(this.getNodes().iterator());
    }

    default public Stream<N> nodesStream() {
        return this.getNodes().stream();
    }

    @Nonnull
    public Collection<? extends N> getNodes();

    @Nonnull
    default public NodeIDs<N> nodeIDs() {
        return new SimpleNodeIDs(this);
    }

    default public GraphDOTHelper<N, ?> getGraphDOTHelper() {
        return new EmptyDOTHelper();
    }

    @Override
    default public Graph<N, ?> asNormalGraph() {
        return new NormalGraphView(this);
    }

    public static class NormalGraphView<N, G extends SimpleGraph<N>>
    extends IndefiniteSimpleGraph.NormalGraphView<N, G>
    implements Graph<N, N> {
        public NormalGraphView(G simpleGraph) {
            super(simpleGraph);
        }

        @Override
        public Collection<? extends N> getNodes() {
            return ((SimpleGraph)this.simpleGraph).getNodes();
        }

        @Override
        public Iterator<N> iterator() {
            return ((SimpleGraph)this.simpleGraph).iterator();
        }

        @Override
        public int size() {
            return ((SimpleGraph)this.simpleGraph).size();
        }

        @Override
        public Stream<N> nodesStream() {
            return ((SimpleGraph)this.simpleGraph).nodesStream();
        }
    }
}

