/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs.base.compact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.commons.util.array.ResizingObjectArray;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.graphs.MutableGraph;
import net.automatalib.graphs.base.compact.CompactEdge;
import net.automatalib.graphs.concepts.NodeIDs;

public abstract class AbstractCompactGraph<E extends CompactEdge<EP>, NP, EP>
implements MutableGraph<Integer, E, NP, EP>,
NodeIDs<Integer> {
    protected int size;
    protected final ResizingObjectArray edges;

    public AbstractCompactGraph() {
        this.size = 0;
        this.edges = new ResizingObjectArray();
    }

    public AbstractCompactGraph(int initialCapacity) {
        this.edges = new ResizingObjectArray(initialCapacity);
    }

    protected List<E> getOutEdgeList(int node) {
        return (List)this.edges.array[node];
    }

    @Override
    public Collection<Integer> getNodes() {
        return CollectionsUtil.intRange(0, this.size);
    }

    @Override
    public NodeIDs<Integer> nodeIDs() {
        return this;
    }

    @Override
    public Collection<E> getOutgoingEdges(Integer node) {
        return this.getOutgoingEdges((int)node);
    }

    @Override
    public Collection<E> getOutgoingEdges(int node) {
        List<E> edgeList = this.getOutEdgeList(node);
        return Collections.unmodifiableCollection(edgeList);
    }

    @Override
    public Integer getTarget(E edge) {
        return ((CompactEdge)edge).getTarget();
    }

    @Override
    public Integer addNode(NP properties) {
        return this.addIntNode(properties);
    }

    public int addIntNode() {
        return this.addIntNode(null);
    }

    public int addIntNode(NP properties) {
        this.edges.ensureCapacity(this.size + 1);
        this.edges.array[this.size] = new ArrayList();
        int n = this.size++;
        this.setNodeProperty(n, properties);
        return n;
    }

    @Override
    public E connect(Integer source, Integer target, EP properties) {
        return this.connect((int)source, (int)target, properties);
    }

    @Override
    public E connect(int source, int target, EP property) {
        E edge = this.createEdge(source, target, property);
        List<E> edges = this.getOutEdgeList(source);
        ((CompactEdge)edge).outIndex = edges.size();
        edges.add(edge);
        return edge;
    }

    @Override
    public CompactEdge<EP> connect(int source, int target) {
        return this.connect(source, target, (EP)null);
    }

    @Override
    public int getNodeId(Integer node) {
        return node;
    }

    @Override
    public Integer getNode(int id) {
        return id;
    }

    public abstract NP getNodeProperties(int var1);

    @Override
    public abstract void setNodeProperty(int var1, NP var2);

    @Override
    public void setNodeProperty(Integer node, NP property) {
        this.setNodeProperty((int)node, property);
    }

    @Override
    public void setEdgeProperty(E edge, EP property) {
        ((CompactEdge)edge).setProperty(property);
    }

    @Override
    public NP getNodeProperty(Integer node) {
        return this.getNodeProperties(node);
    }

    @Override
    public EP getEdgeProperty(E edge) {
        return ((CompactEdge)edge).getProperty();
    }

    protected abstract E createEdge(int var1, int var2, EP var3);
}

