/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs.dot;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.graphs.dot.EmptyDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;

public class DefaultDOTHelper<N, E>
extends EmptyDOTHelper<N, E> {
    protected static final String START_PREFIX = "__start";
    private final GraphDOTHelper<N, ? super E> delegate;

    public DefaultDOTHelper() {
        this(null);
    }

    public DefaultDOTHelper(GraphDOTHelper<N, ? super E> delegate) {
        this.delegate = delegate;
    }

    protected Collection<? extends N> initialNodes() {
        return Collections.emptySet();
    }

    @Override
    public void writePreamble(Appendable a) throws IOException {
        if (this.delegate != null) {
            this.delegate.writePreamble(a);
        }
        int size = this.initialNodes().size();
        for (int i = 0; i < size; ++i) {
            a.append(START_PREFIX).append(Integer.toString(i));
            a.append(" [label=\"\" shape=\"none\"];\n");
        }
    }

    @Override
    public void writePostamble(Mapping<N, String> identifiers, Appendable a) throws IOException {
        if (this.delegate != null) {
            this.delegate.writePostamble(identifiers, a);
        }
        Collection<N> initials = this.initialNodes();
        int i = 0;
        for (N init : initials) {
            a.append(START_PREFIX).append(Integer.toString(i++));
            a.append(" -> ").append(identifiers.get(init)).append(";\n");
        }
    }

    @Override
    public boolean getNodeProperties(N node, Map<String, String> properties) {
        if (this.delegate != null && !this.delegate.getNodeProperties(node, properties)) {
            return false;
        }
        if (!properties.containsKey("label")) {
            String label = String.valueOf(node);
            properties.put("label", label);
        }
        if (!properties.containsKey("shape")) {
            properties.put("shape", "circle");
        }
        return true;
    }

    @Override
    public boolean getEdgeProperties(N src, E edge, N tgt, Map<String, String> properties) {
        if (this.delegate != null) {
            return this.delegate.getEdgeProperties(src, edge, tgt, properties);
        }
        return true;
    }
}

