/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.graphs.SimpleGraph;
import net.automatalib.graphs.concepts.NodeIDs;

public class SimpleNodeIDs<N>
implements NodeIDs<N> {
    private final Map<N, Integer> nodeIds;
    private final List<N> nodes;

    public SimpleNodeIDs(SimpleGraph<N> graph) {
        this.nodes = new ArrayList<N>(graph.getNodes());
        int numNodes = this.nodes.size();
        this.nodeIds = new HashMap<N, Integer>((int)((double)numNodes / 0.75) + 1);
        for (int i = 0; i < numNodes; ++i) {
            N node = this.nodes.get(i);
            this.nodeIds.put(node, i);
        }
    }

    @Override
    public int getNodeId(N node) {
        return this.nodeIds.get(node);
    }

    @Override
    public N getNode(int id) {
        return this.nodes.get(id);
    }
}

