/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa;

import javax.annotation.Nonnull;

public enum Acceptance {
    FALSE{

        @Override
        public boolean toBoolean() {
            return false;
        }
    }
    ,
    TRUE{

        @Override
        public boolean toBoolean() {
            return true;
        }
    }
    ,
    DONT_KNOW{

        @Override
        public boolean toBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean conflicts(boolean val) {
            return false;
        }
    };


    @Nonnull
    public static Acceptance fromBoolean(boolean val) {
        return val ? TRUE : FALSE;
    }

    public abstract boolean toBoolean();

    public boolean conflicts(boolean val) {
        return val != this.toBoolean();
    }
}

