/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.tree;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.incremental.dfa.Acceptance;

@ParametersAreNonnullByDefault
public final class Node<I> {
    private Acceptance acceptance;
    private Node<I>[] children;

    public Node() {
        this(Acceptance.DONT_KNOW);
    }

    public Node(Acceptance acceptance) {
        this.acceptance = acceptance;
    }

    public Acceptance getAcceptance() {
        return this.acceptance;
    }

    public void setAcceptance(Acceptance acceptance) {
        this.acceptance = acceptance;
    }

    @Nullable
    public Node<I> getChild(int idx) {
        if (this.children == null) {
            return null;
        }
        return this.children[idx];
    }

    public void setChild(int idx, int alphabetSize, Node<I> child) {
        if (this.children == null) {
            this.children = new Node[alphabetSize];
        }
        this.children[idx] = child;
    }

    public void makeSink() {
        this.children = null;
        this.acceptance = Acceptance.FALSE;
    }
}

